/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.api.blas;

import org.nd4j.linalg.api.buffer.DataBuffer;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class BlasBufferUtil {
    public static long getBlasOffset(INDArray arr) {
        return arr.offset();
    }

    public static int getBlasStride(INDArray arr) {
        return arr.elementWiseStride();
    }

    public static float[] getFloatData(INDArray buf) {
        if (buf.data().dataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Float data must be obtained from a float buffer");
        }
        if (buf.data().allocationMode() == DataBuffer.AllocationMode.HEAP) {
            return buf.data().asFloat();
        }
        float[] ret = new float[(int)buf.length()];
        INDArray linear = buf.reshape(-1L);
        int i = 0;
        while ((long)i < buf.length()) {
            ret[i] = linear.getFloat((long)i);
            ++i;
        }
        return ret;
    }

    public static double[] getDoubleData(INDArray buf) {
        if (buf.data().dataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Double data must be obtained from a double buffer");
        }
        if (buf.data().allocationMode() == DataBuffer.AllocationMode.HEAP) {
            return buf.data().asDouble();
        }
        double[] ret = new double[(int)buf.length()];
        INDArray linear = buf.reshape(-1L);
        int i = 0;
        while ((long)i < buf.length()) {
            ret[i] = linear.getDouble((long)i);
            ++i;
        }
        return ret;
    }

    public static char getCharForTranspose(INDArray arr) {
        return 'n';
    }

    public static int getStrideForOrdering(INDArray arr) {
        if (arr.ordering() == 'f') {
            return BlasBufferUtil.getBlasStride(arr);
        }
        return arr.stride(1);
    }

    public static long getDimension(INDArray arr, boolean defaultRows) {
        if (arr.isVector()) {
            return defaultRows ? (long)arr.rows() : (long)arr.columns();
        }
        if (arr.ordering() == 'c') {
            return defaultRows ? (long)arr.columns() : (long)arr.rows();
        }
        return defaultRows ? (long)arr.rows() : (long)arr.columns();
    }

    public static int getLd(INDArray arr) {
        if (arr.isVector()) {
            return (int)arr.length();
        }
        return arr.ordering() == 'c' ? (int)arr.size(1) : (int)arr.size(0);
    }

    public static float[] getFloatData(DataBuffer buf) {
        if (buf.allocationMode() == DataBuffer.AllocationMode.HEAP) {
            return buf.asFloat();
        }
        float[] ret = new float[(int)buf.length()];
        int i = 0;
        while ((long)i < buf.length()) {
            ret[i] = buf.getFloat(i);
            ++i;
        }
        return ret;
    }

    public static double[] getDoubleData(DataBuffer buf) {
        if (buf.allocationMode() == DataBuffer.AllocationMode.HEAP) {
            return buf.asDouble();
        }
        double[] ret = new double[(int)buf.length()];
        int i = 0;
        while ((long)i < buf.length()) {
            ret[i] = buf.getDouble(i);
            ++i;
        }
        return ret;
    }

    public static void setData(float[] data, INDArray toSet) {
        if (toSet.data().dataType() != DataType.FLOAT) {
            throw new IllegalArgumentException("Unable to set double data for opType " + (Object)((Object)toSet.data().dataType()));
        }
        if (toSet.data().allocationMode() == DataBuffer.AllocationMode.HEAP) {
            Object array = toSet.data().array();
            if (array == data) {
                return;
            }
            float[] d = (float[])array;
            if (toSet.offset() == 0L && toSet.length() == (long)data.length) {
                System.arraycopy(data, 0, d, 0, d.length);
            } else {
                int count = 0;
                for (int i = 0; i < data.length; ++i) {
                    int dIndex = (int)toSet.offset() + i * toSet.stride(-1);
                    d[dIndex] = data[count++];
                }
            }
        } else {
            DataBuffer underlyingData = toSet.data();
            if ((long)data.length == toSet.length() && toSet.offset() == 0L) {
                int i = 0;
                while ((long)i < toSet.length()) {
                    underlyingData.put((long)i, data[i]);
                    ++i;
                }
            } else {
                int count = 0;
                for (int i = 0; i < data.length; ++i) {
                    int dIndex = (int)toSet.offset() + i * toSet.stride(-1);
                    underlyingData.put((long)dIndex, data[count++]);
                }
            }
        }
    }

    public static void setData(double[] data, INDArray toSet) {
        if (toSet.data().dataType() != DataType.DOUBLE) {
            throw new IllegalArgumentException("Unable to set double data for opType " + (Object)((Object)toSet.data().dataType()));
        }
        if (toSet.data().allocationMode() == DataBuffer.AllocationMode.HEAP) {
            Object array = toSet.data().array();
            if (array == data) {
                return;
            }
            double[] d = (double[])array;
            if (toSet.offset() == 0L && toSet.length() == (long)data.length) {
                System.arraycopy(data, 0, d, 0, d.length);
            } else {
                int count = 0;
                for (int i = 0; i < data.length; ++i) {
                    int dIndex = (int)toSet.offset() + i * toSet.stride(-1);
                    d[dIndex] = data[count++];
                }
            }
        } else {
            DataBuffer underlyingData = toSet.data();
            if ((long)data.length == toSet.length() && toSet.offset() == 0L) {
                int i = 0;
                while ((long)i < toSet.length()) {
                    underlyingData.put((long)i, data[i]);
                    ++i;
                }
            } else {
                int count = 0;
                for (int i = 0; i < data.length; ++i) {
                    int dIndex = (int)toSet.offset() + i * toSet.stride(-1);
                    underlyingData.put((long)dIndex, data[count++]);
                }
            }
        }
    }
}

