/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import lombok.NonNull;
import org.nd4j.autodiff.samediff.internal.DependencyList;
import org.nd4j.common.base.Preconditions;
import org.nd4j.common.function.Predicate;
import org.nd4j.common.primitives.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDependencyTracker<T, D> {
    private static final Logger log = LoggerFactory.getLogger(AbstractDependencyTracker.class);
    private final Map<T, Set<D>> dependencies;
    private final Map<T, Set<Pair<D, D>>> orDependencies;
    private final Map<D, Set<T>> reverseDependencies = new HashMap<D, Set<T>>();
    private final Map<D, Set<T>> reverseOrDependencies = new HashMap<D, Set<T>>();
    private final Set<D> satisfiedDependencies = new HashSet<D>();
    private final Set<T> allSatisfied;
    private final Queue<T> allSatisfiedQueue = new LinkedList<T>();

    protected AbstractDependencyTracker() {
        this.dependencies = this.newTMap();
        this.orDependencies = this.newTMap();
        this.allSatisfied = this.newTSet();
    }

    protected abstract Map<T, ?> newTMap();

    protected abstract Set<T> newTSet();

    protected abstract String toStringT(T var1);

    protected abstract String toStringD(D var1);

    public void clear() {
        this.dependencies.clear();
        this.orDependencies.clear();
        this.reverseDependencies.clear();
        this.reverseOrDependencies.clear();
        this.satisfiedDependencies.clear();
        this.allSatisfied.clear();
        this.allSatisfiedQueue.clear();
    }

    public boolean isEmpty() {
        return this.dependencies.isEmpty() && this.orDependencies.isEmpty() && this.allSatisfiedQueue.isEmpty();
    }

    public boolean isSatisfied(@NonNull D x) {
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        return this.satisfiedDependencies.contains(x);
    }

    public void markSatisfied(@NonNull D x, boolean satisfied) {
        block19: {
            block18: {
                Set<T> set;
                if (x == null) {
                    throw new NullPointerException("x is marked non-null but is null");
                }
                if (!satisfied) break block18;
                boolean alreadySatisfied = this.satisfiedDependencies.contains(x);
                if (alreadySatisfied) break block19;
                this.satisfiedDependencies.add(x);
                Set<T> s = this.reverseDependencies.get(x);
                Set<T> s2 = this.reverseOrDependencies.get(x);
                if (s != null && s2 != null) {
                    set = this.newTSet();
                    set.addAll(s);
                    set.addAll(s2);
                } else if (s != null) {
                    set = s;
                } else if (s2 != null) {
                    set = s2;
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace("No values depend on: {}", (Object)this.toStringD(x));
                    }
                    return;
                }
                for (T t : set) {
                    Set<D> required = this.dependencies.get(t);
                    Set<Pair<D, D>> requiredOr = this.orDependencies.get(t);
                    boolean allSatisfied = true;
                    if (required != null) {
                        for (D d : required) {
                            if (this.isSatisfied(d)) continue;
                            allSatisfied = false;
                            break;
                        }
                    }
                    if (allSatisfied && requiredOr != null) {
                        for (Pair pair : requiredOr) {
                            if (this.isSatisfied(pair.getFirst()) || this.isSatisfied(pair.getSecond())) continue;
                            allSatisfied = false;
                            break;
                        }
                    }
                    if (!allSatisfied || this.allSatisfied.contains(t)) continue;
                    this.allSatisfied.add(t);
                    this.allSatisfiedQueue.add(t);
                }
                break block19;
            }
            this.satisfiedDependencies.remove(x);
            if (!this.allSatisfied.isEmpty()) {
                Set<T> orReverse;
                Set<T> reverse = this.reverseDependencies.get(x);
                if (reverse != null) {
                    for (T y : reverse) {
                        if (!this.allSatisfied.contains(y)) continue;
                        this.allSatisfied.remove(y);
                        this.allSatisfiedQueue.remove(y);
                    }
                }
                if ((orReverse = this.reverseOrDependencies.get(x)) != null) {
                    for (T y : orReverse) {
                        if (!this.allSatisfied.contains(y) || this.isAllSatisfied(y)) continue;
                        this.allSatisfied.remove(y);
                        this.allSatisfiedQueue.remove(y);
                    }
                }
            }
        }
    }

    public boolean hasDependency(@NonNull T y) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        Set<D> s1 = this.dependencies.get(y);
        if (s1 != null && !s1.isEmpty()) {
            return true;
        }
        Set<Pair<D, D>> s2 = this.orDependencies.get(y);
        return s2 != null && !s2.isEmpty();
    }

    public DependencyList<T, D> getDependencies(@NonNull T y) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        Set<D> s1 = this.dependencies.get(y);
        Set<Pair<D, D>> s2 = this.orDependencies.get(y);
        ArrayList<D> l1 = s1 == null ? null : new ArrayList<D>(s1);
        ArrayList<Pair<D, D>> l2 = s2 == null ? null : new ArrayList<Pair<D, D>>(s2);
        return new DependencyList<T, D>(y, l1, l2);
    }

    public void addDependency(@NonNull T y, @NonNull D x) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (!this.dependencies.containsKey(y)) {
            this.dependencies.put(y, new HashSet());
        }
        if (!this.reverseDependencies.containsKey(x)) {
            this.reverseDependencies.put(x, this.newTSet());
        }
        this.dependencies.get(y).add(x);
        this.reverseDependencies.get(x).add(y);
        this.checkAndUpdateIfAllSatisfied(y);
    }

    protected void checkAndUpdateIfAllSatisfied(@NonNull T y) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        boolean allSat = this.isAllSatisfied(y);
        if (allSat) {
            if (!this.allSatisfied.contains(y)) {
                this.allSatisfied.add(y);
                this.allSatisfiedQueue.add(y);
            }
        } else if (this.allSatisfied.contains(y)) {
            if (!this.allSatisfiedQueue.contains(y)) {
                StringBuilder sb = new StringBuilder();
                sb.append("Dependent object \"").append(this.toStringT(y)).append("\" was previously processed after all dependencies").append(" were marked satisfied, but is now additional dependencies have been added.\n");
                DependencyList<T, D> dl = this.getDependencies(y);
                if (dl.getDependencies() != null) {
                    sb.append("Dependencies:\n");
                    for (Object object : dl.getDependencies()) {
                        sb.append(object).append(" - ").append(this.isSatisfied(object) ? "Satisfied" : "Not satisfied").append("\n");
                    }
                }
                if (dl.getOrDependencies() != null) {
                    sb.append("Or dependencies:\n");
                    for (Pair pair : dl.getOrDependencies()) {
                        sb.append(pair).append(" - satisfied=(").append(this.isSatisfied(pair.getFirst())).append(",").append(this.isSatisfied(pair.getSecond())).append(")");
                    }
                }
                throw new IllegalStateException(sb.toString());
            }
            this.allSatisfied.remove(y);
            this.allSatisfiedQueue.remove(y);
        }
    }

    protected boolean isAllSatisfied(@NonNull T y) {
        boolean retVal;
        block4: {
            Pair<D, D> p;
            Set<Pair<D, D>> set2;
            if (y == null) {
                throw new NullPointerException("y is marked non-null but is null");
            }
            Set<D> set1 = this.dependencies.get(y);
            retVal = true;
            if (set1 != null) {
                D d;
                Iterator<D> iterator = set1.iterator();
                while (iterator.hasNext() && (retVal = this.isSatisfied(d = iterator.next()))) {
                }
            }
            if (!retVal || (set2 = this.orDependencies.get(y)) == null) break block4;
            Iterator<Pair<D, D>> iterator = set2.iterator();
            while (iterator.hasNext() && (retVal = this.isSatisfied((p = iterator.next()).getFirst()) || this.isSatisfied(p.getSecond()))) {
            }
        }
        return retVal;
    }

    public void removeDependency(@NonNull T y, @NonNull D x) {
        Set<Pair<D, D>> s3;
        Set<T> s2;
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (x == null) {
            throw new NullPointerException("x is marked non-null but is null");
        }
        if (!this.dependencies.containsKey(y) && !this.orDependencies.containsKey(y)) {
            return;
        }
        Set<D> s = this.dependencies.get(y);
        if (s != null) {
            s.remove(x);
            if (s.isEmpty()) {
                this.dependencies.remove(y);
            }
        }
        if ((s2 = this.reverseDependencies.get(x)) != null) {
            s2.remove(y);
            if (s2.isEmpty()) {
                this.reverseDependencies.remove(x);
            }
        }
        if ((s3 = this.orDependencies.get(y)) != null) {
            boolean removedReverse = false;
            Iterator<Pair<D, D>> iter = s3.iterator();
            while (iter.hasNext()) {
                Pair<D, D> p = iter.next();
                if (!x.equals(p.getFirst()) && !x.equals(p.getSecond())) continue;
                iter.remove();
                if (removedReverse) continue;
                Set<T> set1 = this.reverseOrDependencies.get(p.getFirst());
                Set<T> set2 = this.reverseOrDependencies.get(p.getSecond());
                set1.remove(y);
                set2.remove(y);
                if (set1.isEmpty()) {
                    this.reverseOrDependencies.remove(p.getFirst());
                }
                if (set2.isEmpty()) {
                    this.reverseOrDependencies.remove(p.getSecond());
                }
                removedReverse = true;
            }
        }
        if (s3 != null && s3.isEmpty()) {
            this.orDependencies.remove(y);
        }
    }

    public void addOrDependency(@NonNull T y, @NonNull D x1, @NonNull D x2) {
        if (y == null) {
            throw new NullPointerException("y is marked non-null but is null");
        }
        if (x1 == null) {
            throw new NullPointerException("x1 is marked non-null but is null");
        }
        if (x2 == null) {
            throw new NullPointerException("x2 is marked non-null but is null");
        }
        if (!this.orDependencies.containsKey(y)) {
            this.orDependencies.put(y, new HashSet());
        }
        if (!this.reverseOrDependencies.containsKey(x1)) {
            this.reverseOrDependencies.put(x1, this.newTSet());
        }
        if (!this.reverseOrDependencies.containsKey(x2)) {
            this.reverseOrDependencies.put(x2, this.newTSet());
        }
        this.orDependencies.get(y).add(new Pair(x1, x2));
        this.reverseOrDependencies.get(x1).add(y);
        this.reverseOrDependencies.get(x2).add(y);
        this.checkAndUpdateIfAllSatisfied(y);
    }

    public boolean hasNewAllSatisfied() {
        return !this.allSatisfiedQueue.isEmpty();
    }

    public T getNewAllSatisfied() {
        Preconditions.checkState((boolean)this.hasNewAllSatisfied(), (String)"No new/unprocessed dependents that are all satisfied");
        return this.allSatisfiedQueue.remove();
    }

    public List<T> getNewAllSatisfiedList() {
        Preconditions.checkState((boolean)this.hasNewAllSatisfied(), (String)"No new/unprocessed dependents that are all satisfied");
        ArrayList<T> ret = new ArrayList<T>(this.allSatisfiedQueue);
        this.allSatisfiedQueue.clear();
        return ret;
    }

    public T getFirstNewAllSatisfiedMatching(@NonNull Predicate<T> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        Preconditions.checkState((boolean)this.hasNewAllSatisfied(), (String)"No new/unprocessed dependents that are all satisfied");
        Object t = this.allSatisfiedQueue.peek();
        if (predicate.test(t)) {
            t = this.allSatisfiedQueue.remove();
            this.allSatisfied.remove(t);
            return t;
        }
        if (this.allSatisfiedQueue.size() > 1) {
            Iterator iter = this.allSatisfiedQueue.iterator();
            while (iter.hasNext()) {
                t = iter.next();
                if (!predicate.test(t)) continue;
                iter.remove();
                this.allSatisfied.remove(t);
                return t;
            }
        }
        return null;
    }

    public Map<T, Set<D>> getDependencies() {
        return this.dependencies;
    }

    public Map<T, Set<Pair<D, D>>> getOrDependencies() {
        return this.orDependencies;
    }

    public Map<D, Set<T>> getReverseDependencies() {
        return this.reverseDependencies;
    }

    public Map<D, Set<T>> getReverseOrDependencies() {
        return this.reverseOrDependencies;
    }

    public Set<D> getSatisfiedDependencies() {
        return this.satisfiedDependencies;
    }

    public Set<T> getAllSatisfied() {
        return this.allSatisfied;
    }

    public Queue<T> getAllSatisfiedQueue() {
        return this.allSatisfiedQueue;
    }
}

