/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.JSCode;
import org.mozilla.javascript.JSDescriptor;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFn;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;

public class JSScript
implements Script,
ScriptOrFn<JSScript> {
    private final JSDescriptor<JSScript> descriptor;
    private final Scriptable homeObject;

    public JSScript(JSDescriptor<JSScript> descriptor, Scriptable homeObject) {
        this.descriptor = descriptor;
        this.homeObject = homeObject;
    }

    @Override
    public JSDescriptor<JSScript> getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Scriptable getHomeObject() {
        return this.homeObject;
    }

    JSCode<JSScript> getCode() {
        return this.descriptor.getCode();
    }

    @Override
    public Object exec(Context cx, Scriptable scope, Scriptable thisObj) {
        Object ret;
        if (!ScriptRuntime.hasTopCall(cx)) {
            ret = ScriptRuntime.doTopCall(this, cx, scope, thisObj, this.descriptor.isStrict());
            cx.processMicrotasks();
        } else {
            ret = this.descriptor.getCode().execute(cx, this, null, scope, thisObj, ScriptRuntime.emptyArgs);
        }
        return ret;
    }
}

