/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.lc.type.TypeInfo;

public class AccessorSlot
extends Slot {
    private static final long serialVersionUID = 1677840254177335827L;
    transient Getter getter;
    transient Setter setter;

    AccessorSlot(Object name, int index) {
        super(name, index, 0);
    }

    AccessorSlot(Slot oldSlot) {
        super(oldSlot);
    }

    @Override
    AccessorSlot copySlot() {
        AccessorSlot newSlot = new AccessorSlot(this);
        newSlot.value = this.value;
        newSlot.getter = this.getter;
        newSlot.setter = this.setter;
        newSlot.next = null;
        newSlot.orderedNext = null;
        return newSlot;
    }

    @Override
    boolean isValueSlot() {
        return false;
    }

    @Override
    boolean isSetterSlot() {
        return true;
    }

    @Override
    ScriptableObject.DescriptorInfo getPropertyDescriptor(Context cx, Scriptable scope) {
        Function f;
        String fName;
        ScriptableObject.DescriptorInfo desc;
        boolean es6;
        int attr = this.getAttributes();
        boolean bl = es6 = cx.getLanguageVersion() >= 200;
        if (es6) {
            desc = new ScriptableObject.DescriptorInfo(ScriptableObject.NOT_FOUND, attr, false);
            if (this.getter == null && this.setter == null) {
                desc.writable = (attr & 1) == 0;
            }
        } else {
            desc = new ScriptableObject.DescriptorInfo(ScriptableObject.NOT_FOUND, attr, this.getter == null && this.setter == null);
        }
        String string = fName = this.name == null ? "f" : this.name.toString();
        if (this.getter != null) {
            f = this.getter.asGetterFunction(fName, scope);
            Object object = desc.getter = f == null ? Undefined.instance : f;
        }
        if (this.setter != null) {
            f = this.setter.asSetterFunction(fName, scope);
            desc.setter = f == null ? Undefined.instance : f;
        } else if (es6) {
            desc.setter = Undefined.instance;
        }
        if (es6) {
            desc.enumerable = (attr & 2) == 0;
            desc.configurable = (attr & 4) == 0;
        }
        return desc;
    }

    @Override
    public boolean setValue(Object value, Scriptable owner, Scriptable start, boolean isThrow) {
        if (this.setter == null) {
            if (this.getter != null) {
                this.throwNoSetterException(start, value);
                return true;
            }
        } else {
            return this.setter.setValue(value, owner, start);
        }
        return super.setValue(value, owner, start, isThrow);
    }

    @Override
    public Object getValue(Scriptable start) {
        if (this.getter != null) {
            return this.getter.getValue(start);
        }
        return super.getValue(start);
    }

    @Override
    Function getSetterFunction(String name, Scriptable scope) {
        if (this.setter == null) {
            return null;
        }
        return this.setter.asSetterFunction(name, scope);
    }

    @Override
    Function getGetterFunction(String name, Scriptable scope) {
        if (this.getter == null) {
            return null;
        }
        return this.getter.asGetterFunction(name, scope);
    }

    @Override
    boolean isSameGetterFunction(Object function) {
        if (function == Scriptable.NOT_FOUND) {
            return true;
        }
        if (this.getter == null) {
            return ScriptRuntime.shallowEq(Undefined.instance, function);
        }
        return this.getter.isSameGetterFunction(function);
    }

    @Override
    boolean isSameSetterFunction(Object function) {
        if (function == Scriptable.NOT_FOUND) {
            return true;
        }
        if (this.setter == null) {
            return ScriptRuntime.shallowEq(Undefined.instance, function);
        }
        return this.setter.isSameSetterFunction(function);
    }

    static interface Getter {
        public Object getValue(Scriptable var1);

        public Function asGetterFunction(String var1, Scriptable var2);

        public boolean isSameGetterFunction(Object var1);
    }

    static interface Setter {
        public boolean setValue(Object var1, Scriptable var2, Scriptable var3);

        public Function asSetterFunction(String var1, Scriptable var2);

        public boolean isSameSetterFunction(Object var1);
    }

    static final class FunctionSetter
    implements Setter {
        final Object target;

        FunctionSetter(Object target) {
            this.target = target;
        }

        @Override
        public boolean setValue(Object value, Scriptable owner, Scriptable start) {
            if (this.target instanceof Function) {
                Function t = (Function)this.target;
                Context cx = Context.getContext();
                t.call(cx, t.getDeclarationScope(), start, new Object[]{value});
            }
            return true;
        }

        @Override
        public Function asSetterFunction(String name, Scriptable scope) {
            return this.target instanceof Function ? (Function)this.target : null;
        }

        @Override
        public boolean isSameSetterFunction(Object function) {
            return ScriptRuntime.shallowEq(this.target instanceof Function ? (Function)this.target : Undefined.instance, function);
        }
    }

    static final class MemberBoxSetter
    implements Setter {
        final MemberBox member;

        MemberBoxSetter(MemberBox member) {
            this.member = member;
        }

        @Override
        public boolean setValue(Object value, Scriptable owner, Scriptable start) {
            Context cx = Context.getContext();
            List<TypeInfo> pTypes = this.member.getArgTypes();
            TypeInfo valueType = pTypes.get(pTypes.size() - 1);
            boolean isNullable = this.member.getArgNullability().isNullable(pTypes.size() - 1);
            int tag = valueType.getTypeTag();
            Object actualArg = FunctionObject.convertArg(cx, start, value, tag, isNullable);
            if (this.member.delegateTo == null) {
                this.member.invoke(start, new Object[]{actualArg});
            } else {
                this.member.invoke(this.member.delegateTo, new Object[]{start, actualArg});
            }
            return true;
        }

        @Override
        public Function asSetterFunction(String name, Scriptable scope) {
            return this.member.asSetterFunction(name, scope);
        }

        @Override
        public boolean isSameSetterFunction(Object function) {
            return this.member.isSameSetterFunction(function);
        }
    }

    static final class FunctionGetter
    implements Getter {
        final Object target;

        FunctionGetter(Object target) {
            this.target = target;
        }

        @Override
        public Object getValue(Scriptable start) {
            if (this.target instanceof Function) {
                Function t = (Function)this.target;
                Context cx = Context.getContext();
                return t.call(cx, t.getDeclarationScope(), start, ScriptRuntime.emptyArgs);
            }
            return Undefined.instance;
        }

        @Override
        public Function asGetterFunction(String name, Scriptable scope) {
            return this.target instanceof Function ? (Function)this.target : null;
        }

        @Override
        public boolean isSameGetterFunction(Object function) {
            return ScriptRuntime.shallowEq(this.target instanceof Function ? (Function)this.target : Undefined.instance, function);
        }
    }

    static final class MemberBoxGetter
    implements Getter {
        final MemberBox member;

        MemberBoxGetter(MemberBox member) {
            this.member = member;
        }

        @Override
        public Object getValue(Scriptable start) {
            if (this.member.delegateTo == null) {
                return this.member.invoke(start, ScriptRuntime.emptyArgs);
            }
            return this.member.invoke(this.member.delegateTo, new Object[]{start});
        }

        @Override
        public Function asGetterFunction(String name, Scriptable scope) {
            return this.member.asGetterFunction(name, scope);
        }

        @Override
        public boolean isSameGetterFunction(Object function) {
            return this.member.isSameGetterFunction(function);
        }
    }
}

