/*
 * Decompiled with CFR 0.152.
 */
package mousio.client.retry;

import mousio.client.ConnectionState;
import mousio.client.retry.RetryPolicy;

public class RetryWithExponentialBackOff
extends RetryPolicy {
    public static final RetryWithExponentialBackOff DEFAULT = new RetryWithExponentialBackOff(20, -1, 10000);
    private final int maxRetryCount;
    private final int maxDelayInMs;

    public RetryWithExponentialBackOff(int startMsBeforeRetry) {
        this(startMsBeforeRetry, -1, 5000);
    }

    public RetryWithExponentialBackOff(int startMsBeforeRetry, int maxRetryCount, int maxDelayInMs) {
        super(startMsBeforeRetry);
        this.maxRetryCount = maxRetryCount;
        this.maxDelayInMs = maxDelayInMs;
        if (startMsBeforeRetry <= 0) {
            throw new IllegalArgumentException("RetryWithExponentialBackOff.startMsBeforeRetry must be > 0!");
        }
        if (maxDelayInMs <= 0) {
            throw new IllegalArgumentException("RetryWithExponentialBackOff.maxDelay must be > 0!");
        }
    }

    @Override
    public boolean shouldRetry(ConnectionState state) {
        if (this.maxRetryCount > 0 && state.retryCount > this.maxRetryCount) {
            return false;
        }
        if (state.msBeforeRetry <= 0) {
            state.msBeforeRetry = this.startRetryTime;
        } else if (state.msBeforeRetry < this.maxDelayInMs) {
            state.msBeforeRetry *= 2;
        }
        if (state.msBeforeRetry > this.maxDelayInMs) {
            state.msBeforeRetry = this.maxDelayInMs;
        }
        return true;
    }
}

