/*
 * Decompiled with CFR 0.152.
 */
package mousio.etcd4j.responses;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import mousio.etcd4j.EtcdUtil;
import mousio.etcd4j.responses.EtcdResponse;
import mousio.etcd4j.responses.EtcdResponseDecoder;
import mousio.etcd4j.responses.EtcdResponseDecoders;

@JsonIgnoreProperties(ignoreUnknown=true)
public class EtcdSelfStatsResponse
implements EtcdResponse {
    public static final EtcdResponseDecoder<EtcdSelfStatsResponse> DECODER = EtcdResponseDecoders.json(EtcdSelfStatsResponse.class);
    private final String id;
    private final String name;
    private final long recvAppendRequestCnt;
    private final double recvBandwidthRate;
    private final double recvPkgRate;
    private final long sendAppendRequestCnt;
    private final Date startTime;
    private final String state;
    private final LeaderInfo leaderInfo;

    EtcdSelfStatsResponse(@JsonProperty(value="id") String id, @JsonProperty(value="name") String name, @JsonProperty(value="recvAppendRequestCnt") long recvAppendRequestCnt, @JsonProperty(value="recvBandwidthRate") double recvBandwidthRate, @JsonProperty(value="recvPkgRate") double recvPkgRate, @JsonProperty(value="sendAppendRequestCnt") long sendAppendRequestCnt, @JsonProperty(value="startTime") String startTime, @JsonProperty(value="state") String state, @JsonProperty(value="leaderInfo") LeaderInfo leaderInfo) {
        this.id = id;
        this.name = name;
        this.recvAppendRequestCnt = recvAppendRequestCnt;
        this.recvBandwidthRate = recvBandwidthRate;
        this.recvPkgRate = recvPkgRate;
        this.sendAppendRequestCnt = sendAppendRequestCnt;
        this.state = state;
        this.leaderInfo = leaderInfo;
        this.startTime = EtcdUtil.convertDate(startTime);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public long getRecvAppendRequestCnt() {
        return this.recvAppendRequestCnt;
    }

    public double getRecvBandwidthRate() {
        return this.recvBandwidthRate;
    }

    public double getRecvPkgRate() {
        return this.recvPkgRate;
    }

    public long getSendAppendRequestCnt() {
        return this.sendAppendRequestCnt;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public String getState() {
        return this.state;
    }

    public LeaderInfo getLeaderInfo() {
        return this.leaderInfo;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LeaderInfo {
        private final String leader;
        private final Date startTime;
        private final String uptime;

        LeaderInfo(@JsonProperty(value="leader") String leader, @JsonProperty(value="startTime") String startTime, @JsonProperty(value="uptime") String uptime) {
            this.leader = leader;
            this.uptime = uptime;
            this.startTime = EtcdUtil.convertDate(startTime);
        }

        public String getLeader() {
            return this.leader;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public String getUptime() {
            return this.uptime;
        }
    }
}

