/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read.partitioner;

import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.MongoConfig;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.read.MongoInputPartition;
import com.mongodb.spark.sql.connector.read.partitioner.PaginatePartitioner;
import com.mongodb.spark.sql.connector.read.partitioner.PartitionerHelper;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class PaginateIntoPartitionsPartitioner
extends PaginatePartitioner {
    public static final String MAX_NUMBER_OF_PARTITIONS_CONFIG = "max.number.of.partitions";
    private static final int MAX_NUMBER_OF_PARTITIONS_DEFAULT = 64;

    @Override
    public List<MongoInputPartition> generatePartitions(ReadConfig readConfig) {
        MongoConfig partitionerOptions = readConfig.getPartitionerOptions();
        int maxNumberOfPartitions = Assertions.validateConfig(partitionerOptions.getInt(MAX_NUMBER_OF_PARTITIONS_CONFIG, 64), i -> i > 0, () -> String.format("Invalid config: %s should be greater than zero.", MAX_NUMBER_OF_PARTITIONS_CONFIG));
        BsonDocument matchQuery = PartitionerHelper.matchQuery(readConfig.getAggregationPipeline());
        long count = (Long)readConfig.withCollection(coll -> coll.countDocuments((Bson)matchQuery));
        if (count <= 1L) {
            LOGGER.warn("Returning a single partition.");
            return PartitionerHelper.SINGLE_PARTITIONER.generatePartitions(readConfig);
        }
        if (count <= (long)maxNumberOfPartitions) {
            LOGGER.warn("Inefficient partitioning, returning a partition per document. Total documents = {}, max documents per partition = {}Decrease the `{}` configuration or use an alternative partitioner.", new Object[]{count, maxNumberOfPartitions, MAX_NUMBER_OF_PARTITIONS_CONFIG});
        }
        int numDocumentsPerPartition = (int)Math.ceil((double)count / (double)maxNumberOfPartitions);
        return this.createMongoInputPartitions(count, numDocumentsPerPartition, readConfig);
    }
}

