/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.read.partitioner;

import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.MongoConfig;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.read.MongoInputPartition;
import com.mongodb.spark.sql.connector.read.partitioner.PaginatePartitioner;
import com.mongodb.spark.sql.connector.read.partitioner.PartitionerHelper;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class PaginateBySizePartitioner
extends PaginatePartitioner {
    public static final String PARTITION_SIZE_MB_CONFIG = "partition.size";
    private static final int PARTITION_SIZE_MB_DEFAULT = 64;

    @Override
    public List<MongoInputPartition> generatePartitions(ReadConfig readConfig) {
        MongoConfig partitionerOptions = readConfig.getPartitionerOptions();
        int partitionSizeBytes = Assertions.validateConfig(partitionerOptions.getInt(PARTITION_SIZE_MB_CONFIG, 64), i -> i > 0, () -> String.format("Invalid config: %s should be greater than zero.", PARTITION_SIZE_MB_CONFIG)) * 1000 * 1000;
        BsonDocument storageStats = PartitionerHelper.storageStats(readConfig);
        if (storageStats.isEmpty()) {
            LOGGER.warn("Unable to get collection stats returning a single partition.");
            return PartitionerHelper.SINGLE_PARTITIONER.generatePartitions(readConfig);
        }
        double avgObjSizeInBytes = storageStats.getNumber((Object)"avgObjSize").doubleValue();
        if (avgObjSizeInBytes >= (double)partitionSizeBytes) {
            LOGGER.warn("Average document size `{}` is greater than the partition size `{}`. Please increase the partition size.Returning a single partition.", (Object)avgObjSizeInBytes, (Object)partitionSizeBytes);
            return PartitionerHelper.SINGLE_PARTITIONER.generatePartitions(readConfig);
        }
        int numDocumentsPerPartition = (int)Math.floor((double)partitionSizeBytes / avgObjSizeInBytes);
        BsonDocument matchQuery = PartitionerHelper.matchQuery(readConfig.getAggregationPipeline());
        long count = matchQuery.isEmpty() ? storageStats.getNumber((Object)"count").longValue() : ((Long)readConfig.withCollection(coll -> coll.countDocuments((Bson)matchQuery))).longValue();
        if (count <= (long)numDocumentsPerPartition) {
            LOGGER.warn("The calculated number of documents per partition {} is less than or equal to the number of matching documents. Returning a single partition.", (Object)numDocumentsPerPartition);
            return PartitionerHelper.SINGLE_PARTITIONER.generatePartitions(readConfig);
        }
        return this.createMongoInputPartitions(count, numDocumentsPerPartition, readConfig);
    }
}

