/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.config;

import com.mongodb.spark.sql.connector.config.MongoConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

class SimpleMongoConfig
implements MongoConfig {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> options;

    SimpleMongoConfig(Map<String, String> options) {
        this.options = options;
    }

    @Override
    public Map<String, String> getOptions() {
        return this.options;
    }

    @Override
    public MongoConfig withOption(String key, String value) {
        HashMap<String, String> mergedOptions = new HashMap<String, String>(this.getOptions());
        mergedOptions.put(key, value);
        return new SimpleMongoConfig(mergedOptions);
    }

    @Override
    public MongoConfig withOptions(Map<String, String> options) {
        HashMap<String, String> mergedOptions = new HashMap<String, String>(this.getOptions());
        mergedOptions.putAll(options);
        return new SimpleMongoConfig(mergedOptions);
    }

    @Override
    public Map<String, String> getOriginals() {
        return this.options;
    }

    public String toString() {
        String cleanedOptions = this.options.entrySet().stream().map(e -> {
            String value = (String)e.getValue();
            if (((String)e.getKey()).contains("connection.uri")) {
                value = "<hidden>";
            }
            return (String)e.getKey() + "=" + value;
        }).collect(Collectors.joining(", "));
        return "MongoConfig{options=" + cleanedOptions + ", usageMode=NotSet}";
    }
}

