/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoNamespace;
import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.config.SimpleMongoConfig;
import com.mongodb.spark.sql.connector.config.WriteConfig;
import com.mongodb.spark.sql.connector.connection.DefaultMongoClientFactory;
import com.mongodb.spark.sql.connector.exceptions.ConfigException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;

public interface MongoConfig
extends Serializable {
    public static final String PREFIX = "spark.mongodb.";
    public static final String WRITE_PREFIX = "spark.mongodb.write.";
    public static final String READ_PREFIX = "spark.mongodb.read.";
    public static final String CLIENT_FACTORY_CONFIG = "mongoClientFactory";
    public static final String CLIENT_FACTORY_DEFAULT = DefaultMongoClientFactory.class.getName();
    public static final String CONNECTION_STRING_CONFIG = "connection.uri";
    public static final String CONNECTION_STRING_DEFAULT = "mongodb://localhost:27017/";
    public static final String DATABASE_NAME_CONFIG = "database";
    public static final String COLLECTION_NAME_CONFIG = "collection";

    @ApiStatus.Internal
    public static MongoConfig createConfig(Map<String, String> options) {
        return new SimpleMongoConfig(options);
    }

    public static ReadConfig readConfig(Map<String, String> options) {
        return new ReadConfig(options);
    }

    public static WriteConfig writeConfig(Map<String, String> options) {
        return new WriteConfig(options);
    }

    public Map<String, String> getOptions();

    public MongoConfig withOption(String var1, String var2);

    public MongoConfig withOptions(Map<String, String> var1);

    public Map<String, String> getOriginals();

    default public ConnectionString getConnectionString() {
        return new ConnectionString(this.getOrDefault(CONNECTION_STRING_CONFIG, CONNECTION_STRING_DEFAULT));
    }

    default public MongoNamespace getNamespace() {
        return new MongoNamespace(this.getDatabaseName(), this.getCollectionName());
    }

    default public String getDatabaseName() {
        throw new UnsupportedOperationException("Unspecialized MongoConfig. Use `mongoConfig.toReadConfig()` or `mongoConfig.toWriteConfig()` to specialize");
    }

    default public String getCollectionName() {
        throw new UnsupportedOperationException("Unspecialized MongoConfig. Use `mongoConfig.toReadConfig()` or `mongoConfig.toWriteConfig()` to specialize");
    }

    default public ReadConfig toReadConfig() {
        if (this instanceof ReadConfig) {
            return (ReadConfig)this;
        }
        return MongoConfig.readConfig(this.getOriginals());
    }

    default public WriteConfig toWriteConfig() {
        if (this instanceof WriteConfig) {
            return (WriteConfig)this;
        }
        return MongoConfig.writeConfig(this.getOriginals());
    }

    default public MongoConfig subConfiguration(String prefix) {
        Assertions.ensureState(() -> prefix.endsWith("."), () -> String.format("Invalid configuration prefix `%s`, it must end with a '.'", prefix));
        return MongoConfig.createConfig(this.getOptions().entrySet().stream().filter(e -> ((String)e.getKey()).toLowerCase(Locale.ROOT).startsWith(prefix.toLowerCase(Locale.ROOT))).collect(Collectors.toMap(e -> ((String)e.getKey()).substring(prefix.length()), Map.Entry::getValue)));
    }

    default public boolean containsKey(String key) {
        return this.getOptions().containsKey(key);
    }

    default public String get(String key) {
        return this.getOptions().get(key.toLowerCase(Locale.ROOT));
    }

    default public String getOrDefault(String key, String defaultValue) {
        return this.getOptions().getOrDefault(key.toLowerCase(Locale.ROOT), defaultValue);
    }

    default public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value.equalsIgnoreCase("true")) {
            return true;
        }
        if (value.equalsIgnoreCase("false")) {
            return false;
        }
        throw new ConfigException(value + " is not a boolean string.");
    }

    default public int getInt(String key, int defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : Assertions.validateConfig(() -> Integer.parseInt(value), () -> String.format("%s did not contain a valid int, got: %s", key, value));
    }

    default public long getLong(String key, long defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : Assertions.validateConfig(() -> Long.parseLong(value), () -> String.format("%s did not contain a valid long, got: %s", key, value));
    }

    default public double getDouble(String key, double defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : Assertions.validateConfig(() -> Double.parseDouble(value), () -> String.format("%s did not contain a valid double, got: %s", key, value));
    }

    default public List<String> getList(String key, List<String> defaultValue) {
        String value = this.get(key);
        return value == null ? defaultValue : Arrays.stream(value.split(",")).map(String::trim).collect(Collectors.toList());
    }
}

