/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.spark.sql.connector;

import com.mongodb.MongoCommandException;
import com.mongodb.MongoNamespace;
import com.mongodb.client.model.Filters;
import com.mongodb.spark.sql.connector.MongoTable;
import com.mongodb.spark.sql.connector.assertions.Assertions;
import com.mongodb.spark.sql.connector.config.MongoConfig;
import com.mongodb.spark.sql.connector.config.ReadConfig;
import com.mongodb.spark.sql.connector.config.WriteConfig;
import com.mongodb.spark.sql.connector.exceptions.MongoSparkException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public class MongoCatalog
implements TableCatalog,
SupportsNamespaces {
    private static final Bson NOT_SYSTEM_NAMESPACE = Filters.not((Bson)Filters.regex((String)"name", (String)"^system\\..*"));
    private static final Bson IS_COLLECTION = Filters.and((Bson[])new Bson[]{NOT_SYSTEM_NAMESPACE, Filters.eq((String)"type", (Object)"collection")});
    private boolean initialized;
    private String name;
    private CaseInsensitiveStringMap options;
    private ReadConfig readConfig;
    private WriteConfig writeConfig;

    public void initialize(String name, CaseInsensitiveStringMap options) {
        Assertions.ensureState(() -> !this.initialized, () -> "The MongoCatalog has already been initialized.");
        this.initialized = true;
        this.name = name;
        this.options = options;
    }

    public String name() {
        this.assertInitialized();
        return this.name;
    }

    public String[][] listNamespaces() {
        this.assertInitialized();
        return this.filterDatabases(new String[0]);
    }

    public String[][] listNamespaces(String[] namespace) throws NoSuchNamespaceException {
        this.assertInitialized();
        if (namespace.length == 0) {
            return this.listNamespaces();
        }
        if (!this.namespaceExists(namespace)) {
            throw new NoSuchNamespaceException(namespace);
        }
        return new String[0][];
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        this.assertInitialized();
        if (!this.namespaceExists(namespace)) {
            throw new NoSuchNamespaceException(namespace);
        }
        return Collections.emptyMap();
    }

    public boolean namespaceExists(String[] namespace) {
        return this.filterDatabases(namespace).length > 0;
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        this.assertInitialized();
        if (this.namespaceExists(namespace)) {
            throw new NamespaceAlreadyExistsException(namespace);
        }
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) {
        this.assertInitialized();
        throw new UnsupportedOperationException("Altering databases is currently not supported");
    }

    public boolean dropNamespace(String[] namespace) {
        this.assertInitialized();
        if (this.namespaceExists(namespace)) {
            MongoConfig.writeConfig((Map<String, String>)this.options).doWithClient(c -> c.getDatabase(namespace[0]).drop());
            return true;
        }
        return false;
    }

    public Identifier[] listTables(String[] namespace) {
        return this.filterCollections(Identifier.of((String[])namespace, (String)""));
    }

    public boolean tableExists(Identifier identifier) {
        this.assertInitialized();
        if (identifier.namespace().length != 1) {
            return false;
        }
        return Arrays.asList(this.listTables(identifier.namespace())).contains(identifier);
    }

    public Table loadTable(Identifier identifier) throws NoSuchTableException {
        this.assertInitialized();
        if (!this.tableExists(identifier)) {
            throw new NoSuchTableException(identifier);
        }
        HashMap<String, String> properties = new HashMap<String, String>((Map<String, String>)this.options);
        properties.put("spark.mongodb.read.database", identifier.namespace()[0]);
        properties.put("spark.mongodb.read.collection", identifier.name());
        return new MongoTable(MongoConfig.readConfig(properties));
    }

    public Table createTable(Identifier identifier, StructType schema, Transform[] partitions, Map<String, String> properties) throws TableAlreadyExistsException {
        this.assertInitialized();
        if (identifier.namespace().length != 1) {
            throw new UnsupportedOperationException(String.format("Invalid namespace: %s", String.join((CharSequence)",", identifier.namespace())));
        }
        if (this.tableExists(identifier)) {
            throw new TableAlreadyExistsException(identifier);
        }
        if (partitions.length > 0) {
            throw new UnsupportedOperationException("Cannot create MongoDB collection with partitions");
        }
        if (!properties.isEmpty()) {
            throw new UnsupportedOperationException(String.format("MongoCatalog.createTable does not support the following options: %s", String.join((CharSequence)",", properties.keySet())));
        }
        this.getWriteConfig().doWithClient(c -> c.getDatabase(identifier.namespace()[0]).createCollection(identifier.name()));
        return new MongoTable(schema, this.getWriteConfig());
    }

    public Table alterTable(Identifier identifier, TableChange ... changes) throws NoSuchTableException {
        this.assertInitialized();
        if (!this.tableExists(identifier)) {
            throw new NoSuchTableException(identifier);
        }
        throw new IllegalArgumentException("Altering collections is not supported.");
    }

    public boolean dropTable(Identifier identifier) {
        this.assertInitialized();
        if (identifier.namespace().length == 1 && this.filterCollections(identifier).length != 0) {
            this.getWriteConfig().doWithClient(c -> c.getDatabase(identifier.namespace()[0]).getCollection(identifier.name()).drop());
            return true;
        }
        return false;
    }

    public void renameTable(Identifier oldIdentifier, Identifier newIdentifier) throws NoSuchTableException, TableAlreadyExistsException {
        if (!this.tableExists(oldIdentifier)) {
            throw new NoSuchTableException(oldIdentifier);
        }
        if (this.tableExists(newIdentifier)) {
            throw new TableAlreadyExistsException(newIdentifier);
        }
        try {
            this.getWriteConfig().doWithClient(c -> c.getDatabase(oldIdentifier.namespace()[0]).getCollection(oldIdentifier.name()).renameCollection(new MongoNamespace(newIdentifier.namespace()[0], newIdentifier.name())));
        }
        catch (MongoCommandException ex) {
            throw new MongoSparkException("Unable to rename table due to: " + ex.getErrorMessage(), ex);
        }
    }

    private void assertInitialized() {
        Assertions.ensureState(() -> this.initialized, () -> "The MongoCatalog has not been initialized.");
    }

    private String[][] filterDatabases(String[] databaseName) {
        this.assertInitialized();
        if (databaseName.length > 1) {
            return new String[0][];
        }
        Bson filter = databaseName.length == 0 ? NOT_SYSTEM_NAMESPACE : Filters.and((Bson[])new Bson[]{Filters.eq((String)"name", (Object)databaseName[0]), NOT_SYSTEM_NAMESPACE});
        return (String[][])this.getReadConfig().withClient(client -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
    }

    private Identifier[] filterCollections(Identifier identifier) {
        this.assertInitialized();
        Assertions.ensureArgument(() -> identifier.namespace().length == 1, () -> "Namespace size must equal 1");
        Bson filter = identifier.name().isEmpty() ? IS_COLLECTION : Filters.and((Bson[])new Bson[]{Filters.eq((String)"name", (Object)identifier.name()), IS_COLLECTION});
        return (Identifier[])this.getReadConfig().withClient(c -> ((ArrayList)c.getDatabase(identifier.namespace()[0]).listCollections().filter(filter).map(d -> Identifier.of((String[])identifier.namespace(), (String)d.getString((Object)"name"))).into(new ArrayList())).toArray(new Identifier[0]));
    }

    private ReadConfig getReadConfig() {
        this.assertInitialized();
        if (this.readConfig == null) {
            this.readConfig = MongoConfig.readConfig((Map<String, String>)this.options);
        }
        return this.readConfig;
    }

    @VisibleForTesting
    WriteConfig getWriteConfig() {
        this.assertInitialized();
        if (this.writeConfig == null) {
            this.writeConfig = MongoConfig.writeConfig((Map<String, String>)this.options);
        }
        return this.writeConfig;
    }

    @TestOnly
    @VisibleForTesting
    void reset(Runnable onReset) {
        if (this.initialized) {
            onReset.run();
            this.initialized = false;
            this.name = null;
            this.options = null;
            this.readConfig = null;
            this.writeConfig = null;
        }
    }
}

