/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadWriteBinding;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.session.ClientSession;
import com.mongodb.session.SessionContext;

class ClientSessionBinding
implements AsyncReadWriteBinding {
    private final AsyncReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    ClientSessionBinding(ClientSession session, boolean ownsSession, AsyncReadWriteBinding wrapped) {
        this.wrapped = (AsyncReadWriteBinding)Assertions.notNull((String)"wrapped", (Object)wrapped);
        this.ownsSession = ownsSession;
        this.session = (ClientSession)Assertions.notNull((String)"session", (Object)session);
        this.sessionContext = new ClientSessionContext(session);
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public void getWriteConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getWriteConnectionSource((SingleResultCallback)new SingleResultCallback<AsyncConnectionSource>(){

            public void onResult(AsyncConnectionSource result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)new SessionBindingAsyncConnectionSource(result), null);
                }
            }
        });
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    public void getReadConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        this.wrapped.getReadConnectionSource((SingleResultCallback)new SingleResultCallback<AsyncConnectionSource>(){

            public void onResult(AsyncConnectionSource result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)new SessionBindingAsyncConnectionSource(result), null);
                }
            }
        });
    }

    public int getCount() {
        return this.wrapped.getCount();
    }

    public AsyncReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    public void release() {
        this.wrapped.release();
        this.closeSessionIfCountIsZero();
    }

    private void closeSessionIfCountIsZero() {
        if (this.getCount() == 0 && this.ownsSession) {
            this.session.close();
        }
    }

    private class SessionBindingAsyncConnectionSource
    implements AsyncConnectionSource {
        private AsyncConnectionSource wrapped;

        SessionBindingAsyncConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            this.wrapped.getConnection(callback);
        }

        public AsyncConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public void release() {
            this.wrapped.release();
            ClientSessionBinding.this.closeSessionIfCountIsZero();
        }
    }
}

