/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.crypt.capi;

import java.util.Objects;
import org.bson.BsonBinary;
import org.bson.BsonDocument;

public final class MongoExplicitEncryptOptions {
    private final BsonBinary keyId;
    private final String keyAltName;
    private final String algorithm;
    private final Long contentionFactor;
    private final String queryType;
    private final BsonDocument rangeOptions;

    public static Builder builder() {
        return new Builder();
    }

    public BsonBinary getKeyId() {
        return this.keyId;
    }

    public String getKeyAltName() {
        return this.keyAltName;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public Long getContentionFactor() {
        return this.contentionFactor;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public BsonDocument getRangeOptions() {
        return this.rangeOptions;
    }

    private MongoExplicitEncryptOptions(Builder builder) {
        this.keyId = builder.keyId;
        this.keyAltName = builder.keyAltName;
        this.algorithm = builder.algorithm;
        this.contentionFactor = builder.contentionFactor;
        this.queryType = builder.queryType;
        this.rangeOptions = builder.rangeOptions;
        if (!Objects.equals(this.algorithm, "Indexed") && !Objects.equals(this.algorithm, "Range")) {
            if (this.contentionFactor != null) {
                throw new IllegalStateException("Invalid configuration, contentionFactor can only be set if algorithm is 'Indexed' or 'Range'");
            }
            if (this.queryType != null) {
                throw new IllegalStateException("Invalid configuration, queryType can only be set if algorithm is 'Indexed' or 'Range'");
            }
        }
    }

    public String toString() {
        return "MongoExplicitEncryptOptions{keyId=" + this.keyId + ", keyAltName='" + this.keyAltName + '\'' + ", algorithm='" + this.algorithm + '\'' + ", contentionFactor=" + this.contentionFactor + ", queryType='" + this.queryType + '\'' + ", rangeOptions=" + this.rangeOptions + '}';
    }

    public static final class Builder {
        private BsonBinary keyId;
        private String keyAltName;
        private String algorithm;
        private Long contentionFactor;
        private String queryType;
        private BsonDocument rangeOptions;

        private Builder() {
        }

        public Builder keyId(BsonBinary keyId) {
            this.keyId = keyId;
            return this;
        }

        public Builder keyAltName(String keyAltName) {
            this.keyAltName = keyAltName;
            return this;
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder contentionFactor(Long contentionFactor) {
            this.contentionFactor = contentionFactor;
            return this;
        }

        public Builder queryType(String queryType) {
            this.queryType = queryType;
            return this;
        }

        public Builder rangeOptions(BsonDocument rangeOptions) {
            this.rangeOptions = rangeOptions;
            return this;
        }

        public MongoExplicitEncryptOptions build() {
            return new MongoExplicitEncryptOptions(this);
        }
    }
}

