/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.crypt.capi;

import com.mongodb.internal.crypt.capi.CAPI;
import com.mongodb.internal.crypt.capi.CAPIHelper;
import com.sun.jna.Pointer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

class MacCallback
implements CAPI.mongocrypt_hmac_fn {
    private final String algorithm;

    MacCallback(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public boolean hmac(Pointer ctx, CAPI.mongocrypt_binary_t key, CAPI.mongocrypt_binary_t in, CAPI.mongocrypt_binary_t out, CAPI.mongocrypt_status_t status) {
        try {
            Mac mac = Mac.getInstance(this.algorithm);
            SecretKeySpec keySpec = new SecretKeySpec(CAPIHelper.toByteArray(key), this.algorithm);
            mac.init(keySpec);
            mac.update(CAPIHelper.toByteArray(in));
            byte[] result = mac.doFinal();
            CAPIHelper.writeByteArrayToBinary(out, result);
            return true;
        }
        catch (Exception e) {
            CAPI.mongocrypt_status_set(status, 1, 0, new CAPI.cstring(e.toString()), -1);
            return false;
        }
    }
}

