/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.util;

import com.mongodb.MongoException;
import com.mongodb.MongoNamespace;
import com.mongodb.client.MongoClient;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.client.model.TimeSeriesGranularity;
import com.mongodb.client.model.TimeSeriesOptions;
import com.mongodb.kafka.connect.sink.MongoSinkConfig;
import com.mongodb.kafka.connect.sink.MongoSinkTopicConfig;
import com.mongodb.kafka.connect.sink.namespace.mapping.DefaultNamespaceMapper;
import com.mongodb.kafka.connect.sink.namespace.mapping.NamespaceMapper;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.MongoClientHelper;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigException;
import org.bson.Document;
import org.bson.conversions.Bson;

public final class TimeseriesValidation {
    private static final String COLLSTATS = "collStats";
    private static final String TIMESERIES = "timeseries";
    private static final String TOPIC_OVERRIDE_PREFIX = "topic.override.";

    public static void validateConfigAndCollection(MongoClient mongoClient, MongoSinkTopicConfig topicConfig, Config config) {
        TimeseriesValidation.validateConfigAndTimeseriesSupport(mongoClient, topicConfig, config);
        if (!topicConfig.isTimeseries() || config.configValues().stream().anyMatch(cv -> !cv.errorMessages().isEmpty())) {
            return;
        }
        NamespaceMapper namespaceMapper = topicConfig.getNamespaceMapper();
        if (namespaceMapper instanceof DefaultNamespaceMapper) {
            ConfigHelper.getConfigByName(config, "timeseries.timefield").ifPresent(configValue -> {
                try {
                    TimeseriesValidation.validateCollection(mongoClient, namespaceMapper.getNamespace(null, null), topicConfig);
                }
                catch (Exception e) {
                    configValue.addErrorMessage(e.getMessage());
                }
            });
        }
    }

    public static void validTopicRegexConfigAndCollection(MongoClient mongoClient, MongoSinkConfig sinkConfig, Config config) {
        assert (sinkConfig.getTopicRegex().isPresent());
        Pattern pattern = sinkConfig.getTopicRegex().get();
        Set<String> topicsWithOverrides = sinkConfig.getOriginals().keySet().stream().filter(k -> k.startsWith(TOPIC_OVERRIDE_PREFIX)).map(k -> k.substring(TOPIC_OVERRIDE_PREFIX.length())).map(k -> {
            int index = k.indexOf(".");
            return k.substring(0, index > 0 ? index : k.length());
        }).filter(k -> k.matches(pattern.pattern())).collect(Collectors.toSet());
        if (!topicsWithOverrides.isEmpty()) {
            topicsWithOverrides.forEach(t -> TimeseriesValidation.validateConfigAndCollection(mongoClient, new MongoSinkTopicConfig((String)t, sinkConfig.getOriginals(), false), config));
        } else {
            TimeseriesValidation.validateConfigAndCollection(mongoClient, new MongoSinkTopicConfig("__default", sinkConfig.getOriginals(), false), config);
        }
    }

    public static void validateCollection(MongoClient mongoClient, MongoNamespace namespace, MongoSinkTopicConfig config) {
        try {
            if (TimeseriesValidation.shouldCreateCollection(mongoClient, namespace)) {
                TimeseriesValidation.createCollection(mongoClient, namespace, TimeseriesValidation.createCollectionOptions(config));
            }
        }
        catch (MongoException e) {
            if (e.getCode() == 48) {
                if (!TimeseriesValidation.isTimeseriesCollection(mongoClient, namespace)) {
                    throw new ConfigException(String.format("A collection already exists for: `%s` that is not a timeseries collection.", namespace.getFullName()), (Object)e);
                }
            } else if (e.getCode() == 13) {
                throw new ConfigException(String.format("Failed to create collection for: `%s`. Unauthorized, user does not have the correct permissions to check for and create the collection. %s", namespace.getFullName(), e.getMessage()), (Object)e);
            }
            throw new ConfigException(String.format("Failed to create collection for: `%s`. %s", namespace.getFullName(), e.getMessage()));
        }
    }

    private static void validateConfigAndTimeseriesSupport(MongoClient mongoClient, MongoSinkTopicConfig topicConfig, Config config) {
        if (!topicConfig.isTimeseries()) {
            String granularity;
            long expireAfter;
            String metaField = topicConfig.getString("timeseries.metafield");
            if (!metaField.equals("")) {
                ConfigHelper.getConfigByName(config, "timeseries.metafield").ifPresent(configValue -> configValue.addErrorMessage(String.format("Missing timeseries configuration: `%s`", "timeseries.timefield")));
            }
            if ((expireAfter = topicConfig.getLong("timeseries.expire.after.seconds").longValue()) != 0L) {
                ConfigHelper.getConfigByName(config, "timeseries.expire.after.seconds").ifPresent(configValue -> configValue.addErrorMessage(String.format("Missing timeseries configuration: `%s`", "timeseries.timefield")));
            }
            if (!(granularity = topicConfig.getString("timeseries.granularity").toLowerCase(Locale.ROOT)).isEmpty()) {
                ConfigHelper.getConfigByName(config, "timeseries.granularity").ifPresent(configValue -> configValue.addErrorMessage(String.format("Missing timeseries configuration: `%s`", "timeseries.timefield")));
            }
        } else if (!MongoClientHelper.isAtleastFiveDotZero(mongoClient)) {
            ConfigHelper.getConfigByName(config, "timeseries.timefield").ifPresent(configValue -> configValue.addErrorMessage("Timeseries support requires MongoDB 5.0 or newer"));
        }
    }

    private static CreateCollectionOptions createCollectionOptions(MongoSinkTopicConfig config) {
        String granularityValue;
        assert (config.isTimeseries());
        TimeSeriesOptions timeSeriesOptions = new TimeSeriesOptions(config.getString("timeseries.timefield").trim());
        String metaField = config.getString("timeseries.metafield").trim();
        if (!metaField.isEmpty()) {
            timeSeriesOptions.metaField(metaField);
        }
        if (!(granularityValue = config.getString("timeseries.granularity").trim().toUpperCase(Locale.ROOT)).isEmpty()) {
            try {
                switch (TimeSeriesGranularity.valueOf((String)granularityValue)) {
                    case SECONDS: {
                        timeSeriesOptions.granularity(TimeSeriesGranularity.SECONDS);
                        break;
                    }
                    case MINUTES: {
                        timeSeriesOptions.granularity(TimeSeriesGranularity.MINUTES);
                        break;
                    }
                    case HOURS: {
                        timeSeriesOptions.granularity(TimeSeriesGranularity.HOURS);
                        break;
                    }
                    default: {
                        throw new ConfigException(String.format("Unsupported  value: '%s'", granularityValue));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException(String.format("Unsupported  value: '%s'", granularityValue));
            }
        }
        CreateCollectionOptions createCollectionOptions = new CreateCollectionOptions();
        createCollectionOptions.timeSeriesOptions(timeSeriesOptions);
        Long expireAfterSeconds = config.getLong("timeseries.expire.after.seconds");
        if (expireAfterSeconds > 0L) {
            createCollectionOptions.expireAfter(expireAfterSeconds.longValue(), TimeUnit.SECONDS);
        }
        return createCollectionOptions;
    }

    private static void createCollection(MongoClient mongoClient, MongoNamespace namespace, CreateCollectionOptions options) {
        mongoClient.getDatabase(namespace.getDatabaseName()).createCollection(namespace.getCollectionName(), options);
    }

    private static boolean shouldCreateCollection(MongoClient mongoClient, MongoNamespace namespace) {
        Document collStats = TimeseriesValidation.getCollStats(mongoClient, namespace);
        if (collStats.containsKey((Object)TIMESERIES)) {
            return false;
        }
        if (collStats.getInteger((Object)"nindexes") > 0) {
            throw new ConfigException(String.format("A collection already exists for: `%s` that is not a timeseries collection.", namespace.getFullName()));
        }
        return true;
    }

    private static Document getCollStats(MongoClient mongoClient, MongoNamespace namespace) {
        return mongoClient.getDatabase(namespace.getDatabaseName()).runCommand((Bson)new Document(COLLSTATS, (Object)namespace.getCollectionName()));
    }

    private static boolean isTimeseriesCollection(MongoClient mongoClient, MongoNamespace namespace) {
        return TimeseriesValidation.getCollStats(mongoClient, namespace).containsKey((Object)TIMESERIES);
    }

    private TimeseriesValidation() {
    }
}

