/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect.source.topic.mapping;

import com.mongodb.kafka.connect.source.MongoSourceConfig;
import com.mongodb.kafka.connect.source.topic.mapping.TopicMapper;
import com.mongodb.kafka.connect.util.BsonDocumentFieldLookup;
import com.mongodb.kafka.connect.util.ConfigHelper;
import com.mongodb.kafka.connect.util.ConnectConfigException;
import java.util.HashMap;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.Document;

public class DefaultTopicMapper
implements TopicMapper {
    private static final String DB_FIELD_PATH = "ns.db";
    private static final String COLL_FIELD_PATH = "ns.coll";
    private static final String ALL = "*";
    private static final String SEPARATOR = ".";
    private String prefix;
    private String suffix;
    private Document topicNamespaceMap;
    private Map<String, String> namespaceTopicCache;

    @Override
    public void configure(MongoSourceConfig config) {
        String prefix = config.getString("topic.prefix");
        String suffix = config.getString("topic.suffix");
        this.prefix = prefix.isEmpty() ? prefix : prefix + SEPARATOR;
        this.suffix = suffix.isEmpty() ? suffix : SEPARATOR + suffix;
        this.topicNamespaceMap = ConfigHelper.documentFromString(config.getString("topic.namespace.map")).orElse(new Document());
        if (this.topicNamespaceMap.values().stream().anyMatch(i -> !(i instanceof String))) {
            throw new ConnectConfigException("topic.namespace.map", config.getString("topic.namespace.map"), String.format("All values of `%s` must be strings", "topic.namespace.map"));
        }
        this.namespaceTopicCache = new HashMap<String, String>();
    }

    @Override
    public String getTopic(BsonDocument changeStreamDocument) {
        String dbName = this.getStringFromPath(DB_FIELD_PATH, changeStreamDocument);
        if (dbName.isEmpty()) {
            return dbName;
        }
        String collName = this.getStringFromPath(COLL_FIELD_PATH, changeStreamDocument);
        String namespace = collName.isEmpty() ? dbName : dbName + SEPARATOR + collName;
        String cachedTopic = this.namespaceTopicCache.get(namespace);
        if (cachedTopic == null) {
            cachedTopic = this.prefix + this.getTopicNameFromNamespaceMap(namespace, dbName, collName) + this.suffix;
            this.namespaceTopicCache.put(namespace, cachedTopic);
        }
        return cachedTopic;
    }

    private String getStringFromPath(String fieldPath, BsonDocument changeStreamDocument) {
        return BsonDocumentFieldLookup.fieldLookup(fieldPath, changeStreamDocument).map(bsonValue -> bsonValue.isString() ? bsonValue.asString().getValue() : "").orElse("");
    }

    private String getTopicNameFromNamespaceMap(String namespace, String dbName, String collName) {
        String exactMatch = (String)this.topicNamespaceMap.get((Object)namespace, (Object)"");
        if (!exactMatch.isEmpty()) {
            return exactMatch;
        }
        String databaseMatch = (String)this.topicNamespaceMap.get((Object)dbName, (Object)"");
        if (!databaseMatch.isEmpty()) {
            return databaseMatch + SEPARATOR + collName;
        }
        return (String)this.topicNamespaceMap.get((Object)ALL, (Object)namespace);
    }
}

