/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.kafka.connect;

import com.mongodb.kafka.connect.source.MongoSourceConfig;
import com.mongodb.kafka.connect.source.MongoSourceTask;
import com.mongodb.kafka.connect.util.ConnectionValidator;
import com.mongodb.kafka.connect.util.ServerApiConfig;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.Config;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.source.SourceConnector;

public class MongoSourceConnector
extends SourceConnector {
    private static final List<String> REQUIRED_SOURCE_ACTIONS = Arrays.asList("changeStream", "find");
    private Map<String, String> settings;

    public void start(Map<String, String> props) {
        this.settings = props;
    }

    public Class<? extends Task> taskClass() {
        return MongoSourceTask.class;
    }

    public Config validate(Map<String, String> connectorConfigs) {
        MongoSourceConfig sourceConfig;
        Config config = super.validate(connectorConfigs);
        try {
            sourceConfig = new MongoSourceConfig(connectorConfigs);
        }
        catch (Exception e) {
            return config;
        }
        ConnectionValidator.validateCanConnect(config, "connection.uri").ifPresent(client -> {
            try {
                ServerApiConfig.validateServerApi(client, config);
                ConnectionValidator.validateUserHasActions(client, sourceConfig.getConnectionString().getCredential(), REQUIRED_SOURCE_ACTIONS, sourceConfig.getString("database"), sourceConfig.getString("collection"), "connection.uri", config);
            }
            catch (Exception exception) {
            }
            finally {
                client.close();
            }
        });
        return config;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        return Collections.singletonList(this.settings);
    }

    public void stop() {
    }

    public ConfigDef config() {
        return MongoSourceConfig.CONFIG;
    }

    public String version() {
        return "1.6.1";
    }
}

