/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.kotlinx;

import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.modules.SerializersModule;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.BsonValueCodec;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.kotlinx.BsonConfiguration;
import org.bson.codecs.kotlinx.BsonEncoder;
import org.bson.types.ObjectId;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalSerializationApi
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0007\b\u0001\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0003<=>B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010(\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020%H\u0016J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020.H\u0002J\b\u0010/\u001a\u00020\u0019H\u0016J/\u00100\u001a\u00020\u0019\"\b\b\u0000\u00101*\u00020.2\f\u00102\u001a\b\u0012\u0004\u0012\u0002H1032\b\u0010\u001a\u001a\u0004\u0018\u0001H1H\u0016\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0016J\u0010\u0010:\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010;\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010\u0003\u001a\u00020\u0004H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/bson/codecs/kotlinx/DefaultBsonEncoder;", "Lorg/bson/codecs/kotlinx/BsonEncoder;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "writer", "Lorg/bson/BsonWriter;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "configuration", "Lorg/bson/codecs/kotlinx/BsonConfiguration;", "(Lorg/bson/BsonWriter;Lkotlinx/serialization/modules/SerializersModule;Lorg/bson/codecs/kotlinx/BsonConfiguration;)V", "deferredElementName", "", "isPolymorphic", "", "mapState", "Lorg/bson/codecs/kotlinx/DefaultBsonEncoder$MapState;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "state", "Lorg/bson/codecs/kotlinx/DefaultBsonEncoder$STATE;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encodeBoolean", "", "value", "encodeBsonValue", "Lorg/bson/BsonValue;", "encodeByte", "", "encodeChar", "", "encodeDouble", "", "encodeElement", "index", "", "encodeEnum", "enumDescriptor", "encodeFloat", "", "encodeInt", "encodeLong", "", "encodeName", "", "encodeNull", "encodeNullableSerializableValue", "T", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeObjectId", "Lorg/bson/types/ObjectId;", "encodeShort", "", "encodeString", "endStructure", "shouldEncodeElementDefault", "Companion", "MapState", "STATE", "bson-kotlinx"})
public final class DefaultBsonEncoder
extends AbstractEncoder
implements BsonEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BsonWriter writer;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final BsonConfiguration configuration;
    private boolean isPolymorphic;
    @NotNull
    private STATE state;
    @NotNull
    private MapState mapState;
    @Nullable
    private String deferredElementName;
    @NotNull
    private static final Set<SerialKind> validKeyKinds;
    @NotNull
    private static final BsonValueCodec bsonValueCodec;

    public DefaultBsonEncoder(@NotNull BsonWriter writer, @NotNull SerializersModule serializersModule, @NotNull BsonConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.writer = writer;
        this.serializersModule = serializersModule;
        this.configuration = configuration;
        this.state = STATE.VALUE;
        this.mapState = new MapState();
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.configuration.getEncodeDefaults();
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (serialKind instanceof StructureKind.LIST) {
            this.writer.writeStartArray();
        } else if (serialKind instanceof PolymorphicKind) {
            this.writer.writeStartDocument();
            this.writer.writeName(this.configuration.getClassDiscriminator());
            this.isPolymorphic = true;
        } else if (serialKind instanceof StructureKind.CLASS ? true : Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            if (this.isPolymorphic) {
                this.isPolymorphic = false;
            } else {
                this.writer.writeStartDocument();
            }
        } else if (serialKind instanceof StructureKind.MAP) {
            this.writer.writeStartDocument();
            this.mapState = new MapState();
        } else {
            throw new SerializationException("Primitives are not supported at top-level");
        }
        return super.beginStructure(descriptor);
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (serialKind instanceof StructureKind.LIST) {
            this.writer.writeEndArray();
        } else if ((Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.MAP.INSTANCE) ? true : Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) ? true : Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.OBJECT.INSTANCE)) {
            this.writer.writeEndDocument();
        } else {
            super.endStructure(descriptor);
        }
    }

    public boolean encodeElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (serialKind instanceof StructureKind.CLASS) {
            String elementName = descriptor.getElementName(index);
            if (descriptor.getElementDescriptor(index).isNullable()) {
                this.deferredElementName = elementName;
            } else {
                this.encodeName(elementName);
            }
        } else if (serialKind instanceof StructureKind.MAP) {
            SerialKind keyKind;
            if (index == 0 && !validKeyKinds.contains(keyKind = descriptor.getElementDescriptor(index).getKind())) {
                throw new SerializationException(StringsKt.trimMargin$default((String)("Invalid key type for " + descriptor.getSerialName() + ".\n                                | Expected STRING or ENUM but found: `" + keyKind + "`."), null, (int)1, null));
            }
            this.state = this.mapState.nextState();
        }
        return true;
    }

    public <T> void encodeNullableSerializableValue(@NotNull SerializationStrategy<? super T> serializer, @Nullable T value) {
        block3: {
            Unit unit;
            Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
            String string = this.deferredElementName;
            if (string != null) {
                String it = string;
                boolean bl = false;
                if (value != null || this.configuration.getExplicitNulls()) {
                    this.encodeName(it);
                    super.encodeNullableSerializableValue(serializer, value);
                }
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            if (unit != null) break block3;
            super.encodeNullableSerializableValue(serializer, value);
        }
    }

    public void encodeByte(byte value) {
        this.encodeInt(value);
    }

    public void encodeChar(char value) {
        this.encodeString(String.valueOf(value));
    }

    public void encodeFloat(float value) {
        this.encodeDouble(value);
    }

    public void encodeShort(short value) {
        this.encodeInt(value);
    }

    public void encodeBoolean(boolean value) {
        this.writer.writeBoolean(value);
    }

    public void encodeDouble(double value) {
        this.writer.writeDouble(value);
    }

    public void encodeInt(int value) {
        this.writer.writeInt32(value);
    }

    public void encodeLong(long value) {
        this.writer.writeInt64(value);
    }

    public void encodeNull() {
        this.writer.writeNull();
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                this.encodeName(value);
                break;
            }
            case 2: {
                this.writer.writeString(value);
            }
        }
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String value = enumDescriptor.getElementName(index);
        switch (WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                this.encodeName(value);
                break;
            }
            case 2: {
                this.writer.writeString(value);
            }
        }
    }

    @Override
    public void encodeObjectId(@NotNull ObjectId value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.writer.writeObjectId(value);
    }

    @Override
    public void encodeBsonValue(@NotNull BsonValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        bsonValueCodec.encode(this.writer, value, EncoderContext.builder().build());
    }

    @Override
    @NotNull
    public BsonWriter writer() {
        return this.writer;
    }

    private final void encodeName(Object value) {
        this.writer.writeName(value.toString());
        this.deferredElementName = null;
        this.state = STATE.VALUE;
    }

    static {
        Object[] objectArray = new SerialKind[]{(SerialKind)PrimitiveKind.STRING.INSTANCE, (SerialKind)PrimitiveKind.CHAR.INSTANCE, (SerialKind)SerialKind.ENUM.INSTANCE};
        validKeyKinds = SetsKt.setOf((Object[])objectArray);
        bsonValueCodec = new BsonValueCodec();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/bson/codecs/kotlinx/DefaultBsonEncoder$Companion;", "", "()V", "bsonValueCodec", "Lorg/bson/codecs/BsonValueCodec;", "getBsonValueCodec", "()Lorg/bson/codecs/BsonValueCodec;", "validKeyKinds", "", "Lkotlinx/serialization/descriptors/SerialKind;", "getValidKeyKinds", "()Ljava/util/Set;", "bson-kotlinx"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<SerialKind> getValidKeyKinds() {
            return validKeyKinds;
        }

        @NotNull
        public final BsonValueCodec getBsonValueCodec() {
            return bsonValueCodec;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\n\u001a\u00020\u0004R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lorg/bson/codecs/kotlinx/DefaultBsonEncoder$MapState;", "", "()V", "currentState", "Lorg/bson/codecs/kotlinx/DefaultBsonEncoder$STATE;", "getCurrentState", "()Lorg/bson/codecs/kotlinx/DefaultBsonEncoder$STATE;", "setCurrentState", "(Lorg/bson/codecs/kotlinx/DefaultBsonEncoder$STATE;)V", "getState", "nextState", "bson-kotlinx"})
    private static final class MapState {
        @NotNull
        private STATE currentState = STATE.VALUE;

        @NotNull
        public final STATE getCurrentState() {
            return this.currentState;
        }

        public final void setCurrentState(@NotNull STATE sTATE) {
            Intrinsics.checkNotNullParameter((Object)((Object)sTATE), (String)"<set-?>");
            this.currentState = sTATE;
        }

        @NotNull
        public final STATE getState() {
            return this.currentState;
        }

        @NotNull
        public final STATE nextState() {
            STATE sTATE;
            switch (WhenMappings.$EnumSwitchMapping$0[this.currentState.ordinal()]) {
                case 1: {
                    sTATE = STATE.NAME;
                    break;
                }
                case 2: {
                    sTATE = STATE.VALUE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            this.currentState = sTATE;
            return this.getState();
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[STATE.values().length];
                try {
                    nArray[STATE.VALUE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[STATE.NAME.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/bson/codecs/kotlinx/DefaultBsonEncoder$STATE;", "", "(Ljava/lang/String;I)V", "NAME", "VALUE", "bson-kotlinx"})
    private static final class STATE
    extends Enum<STATE> {
        public static final /* enum */ STATE NAME = new STATE();
        public static final /* enum */ STATE VALUE = new STATE();
        private static final /* synthetic */ STATE[] $VALUES;

        public static STATE[] values() {
            return (STATE[])$VALUES.clone();
        }

        public static STATE valueOf(String value) {
            return Enum.valueOf(STATE.class, value);
        }

        static {
            $VALUES = sTATEArray = new STATE[]{STATE.NAME, STATE.VALUE};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[STATE.values().length];
            try {
                nArray[STATE.NAME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[STATE.VALUE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

