/*
 * Decompiled with CFR 0.152.
 */
package org.moditect.mavenplugin.add;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.AndArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExclusionArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.moditect.commands.AddModuleInfo;
import org.moditect.internal.compiler.ModuleInfoCompiler;
import org.moditect.mavenplugin.add.model.MainModuleConfiguration;
import org.moditect.mavenplugin.add.model.ModuleConfiguration;
import org.moditect.mavenplugin.common.model.ArtifactConfiguration;
import org.moditect.mavenplugin.generate.ModuleInfoGenerator;
import org.moditect.mavenplugin.generate.model.ArtifactIdentifier;
import org.moditect.mavenplugin.util.ArtifactResolutionHelper;
import org.moditect.model.DependencyDescriptor;
import org.moditect.model.GeneratedModuleInfo;

@Mojo(name="add-module-info", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class AddModuleInfoMojo
extends AbstractMojo {
    private static final String MODULE_INFO_CLASS = "module-info.class";
    private static final Pattern VERSIONED_MODULE_INFO = Pattern.compile("META-INF/versions/\\d+/module-info.class");
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true, required=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.artifactId}", readonly=true, required=true)
    private String artifactId;
    @Parameter(defaultValue="${project.version}", readonly=true, required=true)
    private String version;
    @Parameter(property="moditect.jvmVersion")
    private String jvmVersion;
    @Parameter(readonly=true, defaultValue="${project.build.directory}/moditect")
    private File workingDirectory;
    @Parameter(readonly=true, defaultValue="${project.build.directory}")
    private File buildDirectory;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/modules")
    private File outputDirectory;
    @Parameter(property="overwriteExistingFiles", defaultValue="false")
    private boolean overwriteExistingFiles;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @Parameter(property="moditect.skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="moditect.failOnWarning", defaultValue="true")
    private boolean failOnWarning;
    @Parameter
    private MainModuleConfiguration module;
    @Parameter
    private List<ModuleConfiguration> modules;
    @Parameter
    private List<Exclusion> exclusions;
    @Parameter
    private List<String> jdepsExtraArgs;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Mojo 'add-module-info' skipped by configuration");
            return;
        }
        if (this.project.getModel().getPackaging().equalsIgnoreCase("pom")) {
            this.getLog().debug((CharSequence)("Mojo 'add-module-info' not executed on packaging type '" + this.project.getModel().getPackaging() + "'"));
            return;
        }
        if (this.exclusions != null) {
            ScopeArtifactFilter scopeFilter = new ScopeArtifactFilter("compile+runtime");
            ExclusionArtifactFilter exclusionFilter = new ExclusionArtifactFilter(this.exclusions);
            this.project.setArtifactFilter((ArtifactFilter)new AndArtifactFilter(Arrays.asList(scopeFilter, exclusionFilter)));
        }
        Path outputPath = this.outputDirectory.toPath();
        this.createDirectories();
        ArtifactResolutionHelper artifactResolutionHelper = new ArtifactResolutionHelper(this.repoSystem, this.repoSession, this.remoteRepos);
        ModuleInfoGenerator moduleInfoGenerator = new ModuleInfoGenerator(this.project, this.repoSystem, this.repoSession, this.remoteRepos, artifactResolutionHelper, this.jdepsExtraArgs, this.getLog(), this.workingDirectory, new File(this.workingDirectory, "generated-sources"));
        this.resolveArtifactsToBeModularized(artifactResolutionHelper);
        Map<ArtifactIdentifier, String> assignedNamesByModule = this.getAssignedModuleNamesByModule(artifactResolutionHelper);
        HashMap<ArtifactIdentifier, Path> modularizedJars = new HashMap<ArtifactIdentifier, Path>();
        if (this.modules != null) {
            for (ModuleConfiguration moduleConfiguration : this.modules) {
                Path inputFile = this.getInputFile(moduleConfiguration, artifactResolutionHelper);
                if (this.isModularJar(inputFile)) {
                    String message = "File " + inputFile.getFileName() + " is already modular";
                    if (this.failOnWarning) {
                        throw new MojoExecutionException(message);
                    }
                    this.getLog().warn((CharSequence)message);
                    continue;
                }
                String moduleInfoSource = this.getModuleInfoSource(inputFile, moduleConfiguration, moduleInfoGenerator, assignedNamesByModule, modularizedJars);
                AddModuleInfo addModuleInfo = new AddModuleInfo(moduleInfoSource, moduleConfiguration.getMainClass(), this.getVersion(moduleConfiguration), inputFile, outputPath, this.jvmVersion, this.overwriteExistingFiles, InstantConverter.convert(this.outputTimestamp));
                addModuleInfo.run();
                if (moduleConfiguration.getArtifact() == null) continue;
                modularizedJars.put(new ArtifactIdentifier(moduleConfiguration.getResolvedArtifact()), outputPath.resolve(inputFile.getFileName()));
            }
        }
        if (this.module != null) {
            Path inputJar = this.buildDirectory.toPath().resolve(this.project.getModel().getBuild().getFinalName() + ".jar");
            if (!Files.exists(inputJar, new LinkOption[0])) {
                throw new MojoExecutionException("Couldn't find file " + inputJar + ". Run this goal for the project's JAR only after the maven-jar-plugin.");
            }
            if (this.isModularJar(inputJar)) {
                String message = "File " + inputJar.getFileName() + " is already modular";
                if (this.failOnWarning) {
                    throw new MojoExecutionException(message);
                }
                this.getLog().warn((CharSequence)message);
                return;
            }
            AddModuleInfo addModuleInfo = new AddModuleInfo(this.getModuleInfoSource(inputJar, this.module, moduleInfoGenerator, assignedNamesByModule, modularizedJars), this.module.getMainClass(), this.version, inputJar, outputPath, this.jvmVersion, this.overwriteExistingFiles, InstantConverter.convert(this.outputTimestamp));
            addModuleInfo.run();
            try {
                Files.copy(outputPath.resolve(inputJar.getFileName()), inputJar, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't replace " + inputJar + " with modularized version", e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isModularJar(Path jarPath) {
        try (JarFile jarFile = new JarFile(jarPath.toFile());){
            JarEntry entry;
            String entryName;
            Enumeration<JarEntry> entries = jarFile.entries();
            do {
                if (!entries.hasMoreElements()) return false;
            } while (!(entryName = (entry = entries.nextElement()).getName()).equals(MODULE_INFO_CLASS) && !VERSIONED_MODULE_INFO.matcher(entryName).matches());
            boolean bl = true;
            return bl;
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Unexpected error when reading " + jarPath.getFileName());
        }
    }

    private void resolveArtifactsToBeModularized(ArtifactResolutionHelper artifactResolutionHelper) throws MojoExecutionException {
        if (this.modules == null) {
            return;
        }
        for (ModuleConfiguration moduleConfiguration : this.modules) {
            ArtifactConfiguration artifact = moduleConfiguration.getArtifact();
            if (artifact == null) continue;
            if (artifact.getVersion() == null) {
                artifact.setVersion(this.determineVersion(artifact));
            }
            moduleConfiguration.setResolvedArtifact(artifactResolutionHelper.resolveArtifact(artifact));
        }
    }

    private String determineVersion(ArtifactConfiguration artifact) throws MojoExecutionException {
        Optional<Dependency> managed;
        Optional<Artifact> resolvedDependency = this.project.getArtifacts().stream().filter(a -> Objects.equals(a.getGroupId(), artifact.getGroupId()) && Objects.equals(a.getArtifactId(), artifact.getArtifactId()) && Objects.equals(a.getClassifier(), artifact.getClassifier()) && Objects.equals(a.getType(), artifact.getType())).findFirst();
        if (resolvedDependency.isPresent()) {
            return resolvedDependency.get().getVersion();
        }
        if (this.project.getDependencyManagement() != null && (managed = this.project.getDependencyManagement().getDependencies().stream().filter(d -> Objects.equals(d.getGroupId(), artifact.getGroupId()) && Objects.equals(d.getArtifactId(), artifact.getArtifactId()) && Objects.equals(d.getClassifier(), artifact.getClassifier()) && Objects.equals(d.getType(), artifact.getType())).findFirst()).isPresent()) {
            return managed.get().getVersion();
        }
        throw new MojoExecutionException("A version must be given for artifact " + artifact.toDependencyString() + ". Either specify one explicitly, add it to the project dependencies or add it to the project's dependency management.");
    }

    private String getVersion(ModuleConfiguration moduleConfiguration) {
        if (moduleConfiguration.getVersion() != null) {
            return moduleConfiguration.getVersion();
        }
        if (moduleConfiguration.getArtifact() != null) {
            return moduleConfiguration.getArtifact().getVersion();
        }
        if (moduleConfiguration.getFile() != null) {
            return null;
        }
        return null;
    }

    private Path getInputFile(ModuleConfiguration moduleConfiguration, ArtifactResolutionHelper artifactResolutionHelper) throws MojoExecutionException {
        if (moduleConfiguration.getFile() != null) {
            if (moduleConfiguration.getArtifact() != null) {
                throw new MojoExecutionException("Only one of 'file' and 'artifact' may be specified, but both are given for" + moduleConfiguration.getArtifact().toDependencyString());
            }
            return moduleConfiguration.getFile().toPath();
        }
        if (moduleConfiguration.getArtifact() != null) {
            return moduleConfiguration.getResolvedArtifact().getFile().toPath();
        }
        throw new MojoExecutionException("One of 'file' and 'artifact' must be specified");
    }

    private String getModuleInfoSource(Path inputFile, ModuleConfiguration moduleConfiguration, ModuleInfoGenerator moduleInfoGenerator, Map<ArtifactIdentifier, String> assignedNamesByModule, Map<ArtifactIdentifier, Path> modularizedJars) throws MojoExecutionException {
        if (moduleConfiguration.getModuleInfo() != null && moduleConfiguration.getModuleInfoSource() == null && moduleConfiguration.getModuleInfoFile() == null) {
            GeneratedModuleInfo generatedModuleInfo = moduleConfiguration.getArtifact() != null ? moduleInfoGenerator.generateModuleInfo(moduleConfiguration.getArtifact(), moduleConfiguration.getAdditionalDependencies(), moduleConfiguration.getModuleInfo(), assignedNamesByModule, modularizedJars) : moduleInfoGenerator.generateModuleInfo(moduleConfiguration.getFile().toPath(), moduleConfiguration.getAdditionalDependencies(), moduleConfiguration.getModuleInfo(), assignedNamesByModule);
            return this.getLines(generatedModuleInfo.getPath());
        }
        if (moduleConfiguration.getModuleInfo() == null && moduleConfiguration.getModuleInfoSource() != null && moduleConfiguration.getModuleInfoFile() == null) {
            return moduleConfiguration.getModuleInfoSource();
        }
        if (moduleConfiguration.getModuleInfo() == null && moduleConfiguration.getModuleInfoSource() == null && moduleConfiguration.getModuleInfoFile() != null) {
            return this.getLines(moduleConfiguration.getModuleInfoFile().toPath());
        }
        throw new MojoExecutionException("Either 'moduleInfo' or 'moduleInfoFile' or 'moduleInfoSource' must be specified for " + inputFile);
    }

    private String getModuleInfoSource(Path inputFile, MainModuleConfiguration moduleConfiguration, ModuleInfoGenerator moduleInfoGenerator, Map<ArtifactIdentifier, String> assignedNamesByModule, Map<ArtifactIdentifier, Path> modularizedJars) throws MojoExecutionException {
        if (moduleConfiguration.getModuleInfo() != null && moduleConfiguration.getModuleInfoSource() == null && moduleConfiguration.getModuleInfoFile() == null) {
            Set<DependencyDescriptor> dependencies = this.project.getArtifacts().stream().map(d -> new DependencyDescriptor(d.getFile().toPath(), d.isOptional(), this.getAssignedModuleName(assignedNamesByModule, (Artifact)d))).collect(Collectors.toSet());
            GeneratedModuleInfo generatedModuleInfo = moduleInfoGenerator.generateModuleInfo(inputFile, dependencies, moduleConfiguration.getModuleInfo());
            return this.getLines(generatedModuleInfo.getPath());
        }
        if (moduleConfiguration.getModuleInfo() == null && moduleConfiguration.getModuleInfoSource() != null && moduleConfiguration.getModuleInfoFile() == null) {
            return moduleConfiguration.getModuleInfoSource();
        }
        if (moduleConfiguration.getModuleInfo() == null && moduleConfiguration.getModuleInfoSource() == null && moduleConfiguration.getModuleInfoFile() != null) {
            return this.getLines(moduleConfiguration.getModuleInfoFile().toPath());
        }
        throw new MojoExecutionException("Either 'moduleInfo' or 'moduleInfoFile' or 'moduleInfoSource' must be specified for <module>.");
    }

    private String getLines(Path file) throws MojoExecutionException {
        try {
            return new String(Files.readAllBytes(file));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Couldn't read file " + file);
        }
    }

    private void createDirectories() {
        File internalGeneratedSourcesDir;
        if (!this.workingDirectory.exists()) {
            this.workingDirectory.mkdirs();
        }
        if (!(internalGeneratedSourcesDir = new File(this.workingDirectory, "generated-sources")).exists()) {
            internalGeneratedSourcesDir.mkdirs();
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
    }

    private Map<ArtifactIdentifier, String> getAssignedModuleNamesByModule(ArtifactResolutionHelper artifactResolutionHelper) throws MojoExecutionException {
        HashMap<ArtifactIdentifier, String> assignedNamesByModule = new HashMap<ArtifactIdentifier, String>();
        if (this.modules == null) {
            return assignedNamesByModule;
        }
        for (ModuleConfiguration configuredModule : this.modules) {
            String assignedName = configuredModule.getModuleInfo() != null ? configuredModule.getModuleInfo().getName() : (configuredModule.getModuleInfoFile() != null ? ModuleInfoCompiler.parseModuleInfo((Path)configuredModule.getModuleInfoFile().toPath()).getNameAsString() : ModuleInfoCompiler.parseModuleInfo((String)configuredModule.getModuleInfoSource()).getNameAsString());
            if (configuredModule.getArtifact() == null) continue;
            assignedNamesByModule.put(new ArtifactIdentifier(configuredModule.getResolvedArtifact()), assignedName);
        }
        return assignedNamesByModule;
    }

    private String getAssignedModuleName(Map<ArtifactIdentifier, String> assignedNamesByModule, Artifact artifact) {
        for (Map.Entry<ArtifactIdentifier, String> assignedNameByModule : assignedNamesByModule.entrySet()) {
            if (!assignedNameByModule.getKey().getGroupId().equals(artifact.getGroupId()) || !assignedNameByModule.getKey().getArtifactId().equals(artifact.getArtifactId()) || (artifact.getClassifier() != null || !assignedNameByModule.getKey().getClassifier().equals("")) && !assignedNameByModule.getKey().getClassifier().equals(artifact.getClassifier()) || !assignedNameByModule.getKey().getExtension().equals(artifact.getType())) continue;
            return assignedNameByModule.getValue();
        }
        return null;
    }

    private static class InstantConverter {
        private static final Instant DATE_MIN = Instant.parse("1980-01-01T00:00:02Z");
        private static final Instant DATE_MAX = Instant.parse("2099-12-31T23:59:59Z");

        private InstantConverter() {
        }

        public static Instant convert(String value) {
            if (value == null) {
                return null;
            }
            if (!value.isEmpty() && InstantConverter.isNumeric(value)) {
                return Instant.ofEpochSecond(Long.parseLong(value.trim()));
            }
            try {
                Instant date = OffsetDateTime.parse(value).withOffsetSameInstant(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS).toInstant();
                if (date.isBefore(DATE_MIN) || date.isAfter(DATE_MAX)) {
                    throw new IllegalArgumentException("'" + date + "' is not within the valid range " + DATE_MIN + " to " + DATE_MAX);
                }
                return date;
            }
            catch (DateTimeParseException pe) {
                throw new IllegalArgumentException("Invalid project.build.outputTimestamp value '" + value + "'", pe);
            }
        }

        private static boolean isNumeric(String str) {
            try {
                Long.parseLong(str.trim());
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
    }
}

