/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.stub.command;

import org.mockftpserver.core.command.AbstractTrackingCommandHandler;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.command.CommandHandler;
import org.mockftpserver.core.command.InvocationRecord;
import org.mockftpserver.core.session.Session;

public abstract class AbstractStubDataCommandHandler
extends AbstractTrackingCommandHandler
implements CommandHandler {
    protected int preliminaryReplyCode = 0;
    protected String preliminaryReplyText = null;
    protected String preliminaryReplyMessageKey = null;
    protected int finalReplyCode = 0;
    protected String finalReplyText = null;
    protected String finalReplyMessageKey = null;

    protected AbstractStubDataCommandHandler() {
        this.setPreliminaryReplyCode(150);
        this.setFinalReplyCode(226);
    }

    @Override
    public final void handleCommand(Command command, Session session, InvocationRecord invocationRecord) throws Exception {
        this.beforeProcessData(command, session, invocationRecord);
        this.sendPreliminaryReply(session);
        session.openDataConnection();
        this.processData(command, session, invocationRecord);
        session.closeDataConnection();
        this.sendFinalReply(session);
        this.afterProcessData(command, session, invocationRecord);
    }

    protected void sendFinalReply(Session session) {
        this.sendReply(session, this.finalReplyCode, this.finalReplyMessageKey, this.finalReplyText, null);
    }

    protected void beforeProcessData(Command command, Session session, InvocationRecord invocationRecord) throws Exception {
    }

    protected abstract void processData(Command var1, Session var2, InvocationRecord var3) throws Exception;

    protected void afterProcessData(Command command, Session session, InvocationRecord invocationRecord) throws Exception {
    }

    private void sendPreliminaryReply(Session session) {
        this.sendReply(session, this.preliminaryReplyCode, this.preliminaryReplyMessageKey, this.preliminaryReplyText, null);
    }

    public void setFinalReplyCode(int finalReplyCode) {
        this.assertValidReplyCode(finalReplyCode);
        this.finalReplyCode = finalReplyCode;
    }

    public void setFinalReplyMessageKey(String finalReplyMessageKey) {
        this.finalReplyMessageKey = finalReplyMessageKey;
    }

    public void setFinalReplyText(String finalReplyText) {
        this.finalReplyText = finalReplyText;
    }

    public void setPreliminaryReplyCode(int preliminaryReplyCode) {
        this.assertValidReplyCode(preliminaryReplyCode);
        this.preliminaryReplyCode = preliminaryReplyCode;
    }

    public void setPreliminaryReplyMessageKey(String preliminaryReplyMessageKey) {
        this.preliminaryReplyMessageKey = preliminaryReplyMessageKey;
    }

    public void setPreliminaryReplyText(String preliminaryReplyText) {
        this.preliminaryReplyText = preliminaryReplyText;
    }
}

