/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.filesystem;

import org.mockftpserver.core.util.Assert;
import org.mockftpserver.fake.filesystem.AbstractFakeFileSystem;
import org.mockftpserver.fake.filesystem.UnixDirectoryListingFormatter;

public class UnixFakeFileSystem
extends AbstractFakeFileSystem {
    public static final String DEFAULT_SYSTEM_NAME = "UNIX";
    public static final char SEPARATOR = '/';

    public UnixFakeFileSystem() {
        this.setDirectoryListingFormatter(new UnixDirectoryListingFormatter());
        this.setSystemName(DEFAULT_SYSTEM_NAME);
    }

    @Override
    protected char getSeparatorChar() {
        return '/';
    }

    @Override
    protected boolean isValidName(String path) {
        Assert.notNull(path, "path");
        return path.matches("\\/|(\\/[^\\/]+\\/?)+");
    }

    @Override
    protected boolean isSeparator(char c) {
        return c == '/';
    }

    @Override
    protected boolean isRoot(String pathComponent) {
        return pathComponent.indexOf(":") != -1;
    }
}

