/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.fake.filesystem;

import org.mockftpserver.fake.filesystem.AbstractFileSystemEntry;
import org.mockftpserver.fake.filesystem.FileSystemEntry;

public class DirectoryEntry
extends AbstractFileSystemEntry {
    public DirectoryEntry() {
    }

    public DirectoryEntry(String path) {
        super(path);
    }

    @Override
    public boolean isDirectory() {
        return true;
    }

    @Override
    public long getSize() {
        return 0L;
    }

    public String toString() {
        return "Directory['" + this.getPath() + "' lastModified=" + this.getLastModified() + "  owner=" + this.getOwner() + "  group=" + this.getGroup() + "  permissions=" + this.getPermissions() + "]";
    }

    @Override
    public FileSystemEntry cloneWithNewPath(String path) {
        DirectoryEntry clone = new DirectoryEntry(path);
        clone.setLastModified(this.getLastModified());
        clone.setOwner(this.getOwner());
        clone.setGroup(this.getGroup());
        clone.setPermissions(this.getPermissions());
        return clone;
    }
}

