/*
 * Decompiled with CFR 0.152.
 */
package org.mockftpserver.stub.command;

import java.io.IOException;
import java.io.InputStream;
import org.mockftpserver.core.MockFtpServerException;
import org.mockftpserver.core.command.Command;
import org.mockftpserver.core.command.CommandHandler;
import org.mockftpserver.core.command.InvocationRecord;
import org.mockftpserver.core.session.Session;
import org.mockftpserver.core.util.Assert;
import org.mockftpserver.stub.command.AbstractStubDataCommandHandler;

public class FileRetrCommandHandler
extends AbstractStubDataCommandHandler
implements CommandHandler {
    public static final String PATHNAME_KEY = "pathname";
    static final int BUFFER_SIZE = 512;
    private String file;

    public FileRetrCommandHandler() {
    }

    public FileRetrCommandHandler(String file) {
        this.setFile(file);
    }

    protected void beforeProcessData(Command command, Session session, InvocationRecord invocationRecord) throws Exception {
        Assert.notNull(this.file, "file");
        invocationRecord.set(PATHNAME_KEY, command.getRequiredParameter(0));
    }

    protected void processData(Command command, Session session, InvocationRecord invocationRecord) {
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(this.file);
        Assert.notNull(inputStream, "InputStream for [" + this.file + "]");
        byte[] buffer = new byte[512];
        try {
            int numBytes;
            while ((numBytes = inputStream.read(buffer)) != -1) {
                this.LOG.trace("Sending " + numBytes + " bytes...");
                session.sendData(buffer, numBytes);
            }
        }
        catch (IOException e) {
            throw new MockFtpServerException(e);
        }
    }

    public void setFile(String file) {
        Assert.notNull(file, "file");
        this.file = file;
    }
}

