/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.dashboard;

import com.google.common.collect.ImmutableList;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;

public class DashboardHandler {
    private static final Map<String, String> MIME_MAP = new HashMap<String, String>();
    private static final List<String> IS_TEST = ImmutableList.of((Object)"css", (Object)"js", (Object)"map", (Object)"json", (Object)"html");

    public DashboardHandler() {
        MIME_MAP.put("css", "text/css; charset=utf-8");
        MIME_MAP.put("js", "application/javascript; charset=UTF-8");
        MIME_MAP.put("map", "application/json; charset=UTF-8");
        MIME_MAP.put("json", "application/json; charset=UTF-8");
        MIME_MAP.put("html", "text/html; charset=utf-8");
        MIME_MAP.put("ico", "image/x-icon");
        MIME_MAP.put("woff2", "application/font-woff2");
        MIME_MAP.put("ttf", "application/octet-stream");
        MIME_MAP.put("png", "image/png");
    }

    public void renderDashboard(ChannelHandlerContext ctx, HttpRequest request) throws Exception {
        HttpResponse response = HttpResponse.notFoundResponse();
        if (request.getMethod().getValue().equals("GET")) {
            InputStream contentStream;
            String path = StringUtils.substringAfter((String)request.getPath().getValue(), (String)"/mockserver/dashboard");
            if (path.isEmpty() || path.equals("/")) {
                path = "/index.html";
            }
            if ((contentStream = DashboardHandler.class.getResourceAsStream("/org/mockserver/dashboard" + path)) != null) {
                String extension = StringUtils.substringAfterLast((String)path, (String)".");
                if (IS_TEST.contains(extension)) {
                    String content = IOUtils.toString((InputStream)contentStream, (String)StandardCharsets.UTF_8.name());
                    response = HttpResponse.response().withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MIME_MAP.get(extension)}).withHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), new String[]{String.valueOf(content.length())}).withBody(content);
                } else {
                    byte[] bytes = IOUtils.toByteArray((InputStream)contentStream);
                    response = HttpResponse.response().withHeader(HttpHeaderNames.CONTENT_TYPE.toString(), new String[]{MIME_MAP.get(extension)}).withHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), new String[]{String.valueOf(bytes.length)}).withBody(bytes);
                }
                if (request.isKeepAlive().booleanValue()) {
                    response.withHeader(HttpHeaderNames.CONNECTION.toString(), new String[]{HttpHeaderValues.KEEP_ALIVE.toString()});
                }
            }
        }
        if (!request.isKeepAlive().booleanValue()) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.writeAndFlush((Object)response);
        }
    }
}

