/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.lifecycle;

import com.google.common.util.concurrent.SettableFuture;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.MessageLogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpStateHandler;
import org.mockserver.scheduler.Scheduler;

public abstract class LifeCycle {
    protected final MockServerLogger mockServerLogger;
    protected EventLoopGroup bossGroup = new NioEventLoopGroup(ConfigurationProperties.nioEventLoopThreadCount());
    protected EventLoopGroup workerGroup = new NioEventLoopGroup(ConfigurationProperties.nioEventLoopThreadCount());
    protected HttpStateHandler httpStateHandler;
    protected ServerBootstrap serverServerBootstrap;
    private List<Future<Channel>> serverChannelFutures = new ArrayList<Future<Channel>>();
    private Scheduler scheduler = new Scheduler();

    protected LifeCycle() {
        this.httpStateHandler = new HttpStateHandler(this.scheduler);
        this.mockServerLogger = this.httpStateHandler.getMockServerLogger();
    }

    public void stop() {
        this.scheduler.shutdown();
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
        this.bossGroup.terminationFuture().syncUninterruptibly();
        this.workerGroup.terminationFuture().syncUninterruptibly();
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public boolean isRunning() {
        return !this.bossGroup.isShuttingDown() || !this.workerGroup.isShuttingDown();
    }

    public List<Integer> getLocalPorts() {
        return this.getBoundPorts(this.serverChannelFutures);
    }

    @Deprecated
    public Integer getPort() {
        return this.getLocalPort();
    }

    public int getLocalPort() {
        return this.getFirstBoundPort(this.serverChannelFutures);
    }

    private Integer getFirstBoundPort(List<Future<Channel>> channelFutures) {
        for (Future<Channel> channelOpened : channelFutures) {
            try {
                return ((InetSocketAddress)channelOpened.get(2L, TimeUnit.SECONDS).localAddress()).getPort();
            }
            catch (Exception e) {
                this.mockServerLogger.trace("Exception while retrieving port from channel future, ignoring port for this channel", new Object[]{e});
            }
        }
        return -1;
    }

    private List<Integer> getBoundPorts(List<Future<Channel>> channelFutures) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        for (Future<Channel> channelOpened : channelFutures) {
            try {
                ports.add(((InetSocketAddress)channelOpened.get(3L, TimeUnit.SECONDS).localAddress()).getPort());
            }
            catch (Exception e) {
                this.mockServerLogger.trace("Exception while retrieving port from channel future, ignoring port for this channel", new Object[]{e});
            }
        }
        return ports;
    }

    public List<Integer> bindServerPorts(List<Integer> requestedPortBindings) {
        return this.bindPorts(this.serverServerBootstrap, requestedPortBindings, this.serverChannelFutures);
    }

    private List<Integer> bindPorts(final ServerBootstrap serverBootstrap, List<Integer> requestedPortBindings, List<Future<Channel>> channelFutures) {
        ArrayList<Integer> actualPortBindings = new ArrayList<Integer>();
        for (final Integer portToBind : requestedPortBindings) {
            try {
                final SettableFuture channelOpened = SettableFuture.create();
                channelFutures.add((Future<Channel>)channelOpened);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            serverBootstrap.bind(portToBind.intValue()).addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) {
                                    if (future.isSuccess()) {
                                        channelOpened.set((Object)future.channel());
                                    } else {
                                        channelOpened.setException(future.cause());
                                    }
                                }
                            }).channel().closeFuture().syncUninterruptibly();
                        }
                        catch (Exception e) {
                            throw new RuntimeException("Exception while binding MockServer to port " + portToBind, e);
                        }
                    }
                }, "MockServer thread for port: " + portToBind).start();
                actualPortBindings.add(((InetSocketAddress)((Channel)channelOpened.get()).localAddress()).getPort());
            }
            catch (Exception e) {
                throw new RuntimeException("Exception while binding MockServer to port " + portToBind, e.getCause());
            }
        }
        return actualPortBindings;
    }

    protected void startedServer(List<Integer> ports) {
        this.mockServerLogger.info(MessageLogEntry.LogMessageType.SERVER_CONFIGURATION, "started on port" + (ports.size() == 1 ? ": " + ports.get(0) : "s: " + ports), new Object[0]);
    }

    static {
        new MockServerLogger();
    }
}

