/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.routing.io;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.VisitAfterIf;
import org.milyn.delivery.annotation.VisitBeforeIf;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.io.AbstractOutputStreamResource;
import org.milyn.javabean.repository.BeanId;
import org.w3c.dom.Element;

@VisitAfterIf(condition="!parameters.containsKey('visitBefore') || parameters.visitBefore.value != 'true'")
@VisitBeforeIf(condition="!parameters.containsKey('visitAfter') || parameters.visitAfter.value != 'true'")
public class OutputStreamRouter
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Consumer {
    @ConfigParam
    private String resourceName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL, defaultVal="UTF-8")
    private String encoding;
    @ConfigParam(name="beanId", use=ConfigParam.Use.REQUIRED)
    private String beanIdName;
    private BeanId beanId;
    @AppContext
    private ApplicationContext applicationContext;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        this.beanId = this.applicationContext.getBeanIdStore().getBeanId(this.beanIdName);
    }

    public boolean consumes(Object object) {
        if (object.equals(this.resourceName)) {
            return true;
        }
        return object.toString().startsWith(this.beanIdName);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.write(executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.write(executionContext);
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.write(executionContext);
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.write(executionContext);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    private void write(ExecutionContext executionContext) {
        Object bean = executionContext.getBeanContext().getBean(this.beanId);
        if (bean == null) {
            throw new SmooksException("A bean with id [" + this.beanId + "] was not found in the executionContext");
        }
        OutputStream out = AbstractOutputStreamResource.getOutputStream((String)this.resourceName, (ExecutionContext)executionContext);
        try {
            if (bean instanceof String) {
                out.write(((String)bean).getBytes(this.encoding));
            } else if (bean instanceof byte[]) {
                out.write(new String((byte[])bean, this.encoding).getBytes());
            } else {
                out = new ObjectOutputStream(out);
                ((ObjectOutputStream)out).writeObject(bean);
            }
            out.flush();
        }
        catch (IOException e) {
            String errorMsg = "IOException while trying to append to file";
            throw new SmooksException("IOException while trying to append to file", (Throwable)e);
        }
    }
}

