/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.binding.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.milyn.javabean.DataEncoder;
import org.milyn.javabean.binding.SerializationContext;
import org.milyn.javabean.binding.model.get.Getter;
import org.milyn.javabean.binding.model.get.GetterGraph;
import org.milyn.javabean.binding.xml.XMLElementSerializationNode;

public abstract class XMLSerializationNode {
    protected QName qName;
    protected XMLElementSerializationNode parent;
    protected DataEncoder encoder;
    protected String defaultVal;
    protected boolean isCollection = false;
    protected NodeGetter nodeGetter;
    protected NodeGetter collectionGetter;

    protected XMLSerializationNode(QName qName) {
        this.qName = qName;
    }

    public QName getQName() {
        return this.qName;
    }

    public XMLElementSerializationNode getParent() {
        return this.parent;
    }

    public void setParent(XMLElementSerializationNode parent) {
        this.parent = parent;
    }

    public void setEncoder(DataEncoder encoder) {
        this.encoder = encoder;
    }

    public void setDefaultVal(String defaultVal) {
        this.defaultVal = defaultVal;
    }

    public void setIsCollection(boolean isCollection) {
        this.isCollection = isCollection;
    }

    public abstract void serialize(Writer var1, SerializationContext var2) throws IOException;

    protected String getValue(SerializationContext context) {
        if (this.nodeGetter != null) {
            Object value = context.getValue(this.nodeGetter.contextObjectName, this.nodeGetter.getter);
            if (value == null && (value = this.defaultVal) == null) {
                return null;
            }
            if (this.encoder != null) {
                return this.encoder.encode(value);
            }
            return value.toString();
        }
        return null;
    }

    public void setGetter(GetterGraph getter) {
        this.nodeGetter = new NodeGetter(getter.getContextObjectName(), getter);
    }

    public void setGetter(Getter getter) {
        this.nodeGetter = new NodeGetter(getter);
    }

    public void setCollectionGetter(String contextObjectName, GetterGraph getter) {
        this.collectionGetter = new NodeGetter(contextObjectName, getter);
    }

    public NodeGetter getNodeGetter() {
        return this.nodeGetter;
    }

    public NodeGetter getCollectionGetter() {
        return this.collectionGetter;
    }

    protected void writeName(Writer outputStream) throws IOException {
        String prefix = this.qName.getPrefix();
        String localPart = this.qName.getLocalPart();
        if (prefix != null && !prefix.equals("")) {
            outputStream.write(prefix);
            outputStream.write(":");
        }
        outputStream.write(localPart);
    }

    public static <T extends XMLSerializationNode> T getNode(QName qName, Collection<T> nodeList) {
        for (XMLSerializationNode node : nodeList) {
            if (!node.getQName().equals(qName)) continue;
            return (T)node;
        }
        return null;
    }

    protected void copyProperties(XMLSerializationNode node) {
        node.qName = this.qName;
        node.encoder = this.encoder;
        node.defaultVal = this.defaultVal;
    }

    public String toString() {
        return this.qName.toString();
    }

    protected boolean hasData(SerializationContext context) {
        return this.nodeGetter == null || context.getValue(this.nodeGetter.contextObjectName, this.nodeGetter.getter) != null;
    }

    protected class NodeGetter {
        protected String contextObjectName;
        protected Getter getter;

        public NodeGetter(Getter getter) {
            this.contextObjectName = SerializationContext.ROOT_OBJ;
            this.getter = getter;
        }

        private NodeGetter(String contextObjectName, Getter getter) {
            this.contextObjectName = contextObjectName;
            this.getter = getter;
        }
    }
}

