/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.binding.model.get;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.milyn.javabean.binding.BeanSerializationException;
import org.milyn.javabean.binding.model.get.Getter;
import org.milyn.util.ClassUtil;

public class BeanGetter<T>
implements Getter<T> {
    private Method getterMethod;

    public BeanGetter(Class<?> beanClass, String property) {
        this.getterMethod = ClassUtil.getGetterMethodByProperty((String)property, beanClass, null);
        if (this.getterMethod == null) {
            throw new IllegalStateException("Failed to get getter method for property '" + property + "' on bean type '" + beanClass.getName() + "'.");
        }
    }

    @Override
    public Object get(T contextObject) throws BeanSerializationException {
        try {
            return this.getterMethod.invoke(contextObject, new Object[0]);
        }
        catch (IllegalArgumentException e) {
            throw new BeanSerializationException("Error invoking bean getter method '" + this.getterMethod.getName() + "' on bean type '" + contextObject.getClass().getName() + "'.", e);
        }
        catch (IllegalAccessException e) {
            throw new BeanSerializationException("Error invoking bean getter method '" + this.getterMethod.getName() + "' on bean type '" + contextObject.getClass().getName() + "'.", e);
        }
        catch (InvocationTargetException e) {
            throw new BeanSerializationException("Error invoking bean getter method '" + this.getterMethod.getName() + "' on bean type '" + contextObject.getClass().getName() + "'.", e.getCause());
        }
    }
}

