/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.dynamic.visitor;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.milyn.SmooksException;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.delivery.sax.SAXUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceReaper
implements DOMVisitBefore {
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        Map<String, String> namespacePrefixMappings = NamespaceReaper.getNamespacePrefixMappings(executionContext);
        NamedNodeMap attributes = element.getAttributes();
        int attributeCount = attributes.getLength();
        for (int i = 0; i < attributeCount; ++i) {
            Attr attr = (Attr)attributes.item(i);
            if (!"http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI())) continue;
            String uri = attr.getValue();
            QName attrQName = SAXUtil.toQName((String)uri, (String)attr.getLocalName(), (String)attr.getNodeName());
            this.addMapping(namespacePrefixMappings, uri, attrQName.getLocalPart());
        }
    }

    private void addMapping(Map<String, String> namespacePrefixMappings, String uri, String prefix) {
        if (uri != null && prefix != null && !namespacePrefixMappings.containsKey(uri)) {
            namespacePrefixMappings.put(uri, prefix);
        }
    }

    public static Map<String, String> getNamespacePrefixMappings(ExecutionContext executionContext) {
        LinkedHashMap namespacePrefixMappings = (LinkedHashMap)executionContext.getAttribute(NamespaceReaper.class);
        if (namespacePrefixMappings == null) {
            namespacePrefixMappings = new LinkedHashMap();
            executionContext.setAttribute(NamespaceReaper.class, namespacePrefixMappings);
        }
        return namespacePrefixMappings;
    }
}

