/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Fragment;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXUtil;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.expression.MVELExpressionEvaluator;
import org.milyn.javabean.Bean;
import org.milyn.javabean.BeanRuntimeInfo;
import org.milyn.javabean.BeanUtils;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.context.BeanIdStore;
import org.milyn.javabean.decoders.PreprocessDecoder;
import org.milyn.javabean.decoders.StringDecoder;
import org.milyn.javabean.lifecycle.BeanContextLifecycleEvent;
import org.milyn.javabean.lifecycle.BeanContextLifecycleObserver;
import org.milyn.javabean.lifecycle.BeanLifecycle;
import org.milyn.javabean.observers.BeanWiringObserver;
import org.milyn.javabean.observers.ListToArrayChangeObserver;
import org.milyn.javabean.repository.BeanId;
import org.milyn.util.ClassUtil;
import org.milyn.util.CollectionsUtil;
import org.milyn.xml.DomUtils;
import org.milyn.xml.NamespaceMappings;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@VisitBeforeReport(condition="parameters.containsKey('wireBeanId') || parameters.containsKey('valueAttributeName')", summary="<#if resource.parameters.wireBeanId??>Create bean lifecycle observer for bean <b>${resource.parameters.wireBeanId}</b>.<#else>Populating <b>${resource.parameters.beanId}</b> with the value from the attribute <b>${resource.parameters.valueAttributeName}</b>.</#if>", detailTemplate="reporting/BeanInstancePopulatorReport_Before.html")
@VisitAfterReport(condition="!parameters.containsKey('wireBeanId') && !parameters.containsKey('valueAttributeName')", summary="Populating <b>${resource.parameters.beanId}</b> with a value from this element.", detailTemplate="reporting/BeanInstancePopulatorReport_After.html")
public class BeanInstancePopulator
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Producer,
Consumer {
    private static final Log logger = LogFactory.getLog(BeanInstancePopulator.class);
    private static final String EXPRESSION_VALUE_VARIABLE_NAME = "_VALUE";
    public static final String VALUE_ATTRIBUTE_NAME = "valueAttributeName";
    public static final String VALUE_ATTRIBUTE_PREFIX = "valueAttributePrefix";
    public static final String NOTIFY_POPULATE = "org.milyn.javabean.notify.populate";
    private String id;
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="wireBeanId", defaultVal="##NULL")
    private String wireBeanIdName;
    @ConfigParam(defaultVal="##NULL")
    private Class<?> wireBeanType;
    @ConfigParam(defaultVal="##NULL")
    private Class<? extends Annotation> wireBeanAnnotation;
    @ConfigParam(defaultVal="##NULL")
    private String expression;
    private MVELExpressionEvaluator expressionEvaluator;
    private boolean expressionHasDataVariable = false;
    @ConfigParam(defaultVal="##NULL")
    private String property;
    @ConfigParam(defaultVal="##NULL")
    private String setterMethod;
    @ConfigParam(defaultVal="##NULL")
    private String valueAttributeName;
    @ConfigParam(defaultVal="##NULL")
    private String valueAttributePrefix;
    private String valueAttributeNS;
    @ConfigParam(name="type", defaultVal="##NULL")
    private String typeAlias;
    @ConfigParam(name="default", defaultVal="##NULL")
    private String defaultVal;
    @ConfigParam(name="org.milyn.javabean.notify.populate", defaultVal="false")
    private boolean notifyPopulate;
    @AppContext
    private ApplicationContext appContext;
    private BeanIdStore beanIdStore;
    private BeanId beanId;
    private BeanId wireBeanId;
    private BeanRuntimeInfo beanRuntimeInfo;
    private BeanRuntimeInfo wiredBeanRuntimeInfo;
    private Method propertySetterMethod;
    private boolean checkedForSetterMethod;
    private boolean isAttribute = true;
    private DataDecoder decoder;
    private String mapKeyAttribute;
    private boolean isBeanWiring;
    private BeanWiringObserver wireByBeanIdObserver;
    private ListToArrayChangeObserver listToArrayChangeObserver;

    public void setBeanId(String beanId) {
        this.beanIdName = beanId;
    }

    public void setWireBeanId(String wireBeanId) {
        this.wireBeanIdName = wireBeanId;
    }

    public void setExpression(MVELExpressionEvaluator expression) {
        this.expressionEvaluator = expression;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setSetterMethod(String setterMethod) {
        this.setterMethod = setterMethod;
    }

    public void setValueAttributeName(String valueAttributeName) {
        this.valueAttributeName = valueAttributeName;
    }

    public void setValueAttributePrefix(String valueAttributePrefix) {
        this.valueAttributePrefix = valueAttributePrefix;
    }

    public void setTypeAlias(String typeAlias) {
        this.typeAlias = typeAlias;
    }

    public void setDecoder(DataDecoder decoder) {
        this.decoder = decoder;
    }

    public void setDefaultVal(String defaultVal) {
        this.defaultVal = defaultVal;
    }

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        this.buildId();
        this.beanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.beanIdName, this.appContext);
        this.isBeanWiring = this.wireBeanIdName != null || this.wireBeanType != null || this.wireBeanAnnotation != null;
        boolean bl = this.isAttribute = this.valueAttributeName != null;
        if (this.valueAttributePrefix != null) {
            Properties namespaces = NamespaceMappings.getMappings((ApplicationContext)this.appContext);
            this.valueAttributeNS = namespaces.getProperty(this.valueAttributePrefix);
        }
        this.beanIdStore = this.appContext.getBeanIdStore();
        this.beanId = this.beanIdStore.getBeanId(this.beanIdName);
        if (this.setterMethod == null && this.property == null) {
            if (this.isBeanWiring && (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.NON_COLLECTION || this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.MAP_COLLECTION)) {
                this.property = this.wireBeanIdName;
            } else if (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.NON_COLLECTION) {
                throw new SmooksConfigurationException("Binding configuration for beanIdName='" + this.beanIdName + "' must contain " + "either a 'property' or 'setterMethod' attribute definition, unless the target bean is a Collection/Array." + "  Bean is type '" + this.beanRuntimeInfo.getPopulateType().getName() + "'.");
            }
        }
        if (this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.MAP_COLLECTION && this.property != null) {
            this.property = this.property.trim();
            if (this.property.length() > 1 && this.property.charAt(0) == '@') {
                this.mapKeyAttribute = this.property.substring(1);
            }
        }
        if (this.expression != null) {
            this.expression = this.expression.trim();
            this.expressionHasDataVariable = this.expression.contains(EXPRESSION_VALUE_VARIABLE_NAME);
            this.expression = this.expression.replace("this.", this.beanIdName + ".");
            if (this.expression.startsWith("+=")) {
                this.expression = this.beanIdName + "." + this.property + " +" + this.expression.substring(2);
            }
            if (this.expression.startsWith("-=")) {
                this.expression = this.beanIdName + "." + this.property + " -" + this.expression.substring(2);
            }
            this.expressionEvaluator = new MVELExpressionEvaluator();
            this.expressionEvaluator.setExpression(this.expression);
            Class<Object> bindingType = this.resolveBindTypeReflectively();
            if (bindingType != null) {
                if (this.typeAlias != null) {
                    bindingType = String.class;
                }
                this.expressionEvaluator.setToType(bindingType);
            }
        }
        if (this.wireBeanIdName != null) {
            this.wireBeanId = this.beanIdStore.getBeanId(this.wireBeanIdName);
            if (this.wireBeanId == null) {
                this.wireBeanId = this.beanIdStore.register(this.wireBeanIdName);
            }
        }
        if (this.isBeanWiring) {
            this.wireByBeanIdObserver = new BeanWiringObserver(this.beanId, this).watchedBeanId(this.wireBeanId).watchedBeanType(this.wireBeanType).watchedBeanAnnotation(this.wireBeanAnnotation);
            if (this.wireBeanId != null) {
                this.listToArrayChangeObserver = new ListToArrayChangeObserver(this.wireBeanId, this.property, this);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Bean Instance Populator created for [" + this.beanIdName + "].  property=" + this.property));
        }
    }

    private void buildId() {
        StringBuilder idBuilder = new StringBuilder();
        idBuilder.append(BeanInstancePopulator.class.getName());
        idBuilder.append("#");
        idBuilder.append(this.beanIdName);
        if (this.property != null) {
            idBuilder.append("#").append(this.property);
        }
        if (this.setterMethod != null) {
            idBuilder.append("#").append(this.setterMethod).append("()");
        }
        if (this.wireBeanIdName != null) {
            idBuilder.append("#").append(this.wireBeanIdName);
        }
        this.id = idBuilder.toString();
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        if (!this.beanExists(executionContext)) {
            logger.debug((Object)("Cannot bind data onto bean '" + this.beanId + "' as bean does not exist in BeanContext."));
            return;
        }
        if (this.isBeanWiring) {
            this.bindBeanValue(executionContext, new Fragment(element));
        } else if (this.isAttribute) {
            this.bindDomDataValue(element, executionContext);
        }
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        if (!this.beanExists(executionContext)) {
            logger.debug((Object)("Cannot bind data onto bean '" + this.beanId + "' as bean does not exist in BeanContext."));
            return;
        }
        if (!this.isBeanWiring && !this.isAttribute) {
            this.bindDomDataValue(element, executionContext);
        }
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        if (!this.beanExists(executionContext)) {
            logger.debug((Object)("Cannot bind data onto bean '" + this.beanId + "' as bean does not exist in BeanContext."));
            return;
        }
        if (this.isBeanWiring) {
            this.bindBeanValue(executionContext, new Fragment(element));
        } else if (this.isAttribute) {
            this.bindSaxDataValue(element, executionContext);
        } else if (this.expressionEvaluator == null || this.expressionHasDataVariable) {
            element.accumulateText();
        }
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        if (!this.beanExists(executionContext)) {
            logger.debug((Object)("Cannot bind data onto bean '" + this.beanId + "' as bean does not exist in BeanContext."));
            return;
        }
        if (!this.isBeanWiring && !this.isAttribute) {
            this.bindSaxDataValue(element, executionContext);
        }
    }

    private boolean beanExists(ExecutionContext executionContext) {
        return executionContext.getBeanContext().getBean(this.beanId) != null;
    }

    private void bindDomDataValue(Element element, ExecutionContext executionContext) {
        String propertyName;
        String dataString = this.isAttribute ? (this.valueAttributeNS != null ? DomUtils.getAttributeValue((Element)element, (String)this.valueAttributeName, (String)this.valueAttributeNS) : DomUtils.getAttributeValue((Element)element, (String)this.valueAttributeName)) : DomUtils.getAllText((Element)element, (boolean)false);
        if (this.mapKeyAttribute != null) {
            propertyName = DomUtils.getAttributeValue((Element)element, (String)this.mapKeyAttribute);
            if (propertyName == null) {
                propertyName = DomUtils.getName((Element)element);
            }
        } else {
            propertyName = this.property != null ? this.property : DomUtils.getName((Element)element);
        }
        if (this.expressionEvaluator != null) {
            this.bindExpressionValue(propertyName, dataString, executionContext, new Fragment(element));
        } else {
            this.decodeAndSetPropertyValue(propertyName, dataString, executionContext, new Fragment(element));
        }
    }

    private void bindSaxDataValue(SAXElement element, ExecutionContext executionContext) {
        String propertyName;
        if (this.mapKeyAttribute != null) {
            propertyName = SAXUtil.getAttribute((String)this.mapKeyAttribute, (Attributes)element.getAttributes(), null);
            if (propertyName == null) {
                propertyName = element.getName().getLocalPart();
            }
        } else {
            propertyName = this.property != null ? this.property : element.getName().getLocalPart();
        }
        String dataString = null;
        if (this.expressionEvaluator == null || this.expressionHasDataVariable) {
            dataString = this.isAttribute ? (this.valueAttributeNS != null ? SAXUtil.getAttribute((String)this.valueAttributeNS, (String)this.valueAttributeName, (Attributes)element.getAttributes(), null) : SAXUtil.getAttribute((String)this.valueAttributeName, (Attributes)element.getAttributes(), null)) : element.getTextContent();
        }
        if (this.expressionEvaluator != null) {
            this.bindExpressionValue(propertyName, dataString, executionContext, new Fragment(element));
        } else {
            this.decodeAndSetPropertyValue(propertyName, dataString, executionContext, new Fragment(element));
        }
    }

    private void bindBeanValue(ExecutionContext executionContext, Fragment source) {
        BeanContext beanContext = executionContext.getBeanContext();
        Object bean = null;
        if (this.wireBeanId != null) {
            bean = beanContext.getBean(this.wireBeanId);
        }
        if (bean != null && !BeanWiringObserver.isMatchingBean(bean, this.wireBeanType, this.wireBeanAnnotation)) {
            bean = null;
        }
        if (bean == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registering bean ADD wiring observer for wiring bean '" + this.wireBeanId + "' onto target bean '" + this.beanId.getName() + "'."));
            }
            beanContext.addObserver((BeanContextLifecycleObserver)this.wireByBeanIdObserver);
        } else {
            this.populateAndSetPropertyValue(bean, beanContext, this.wireBeanId, executionContext, source);
        }
    }

    public void populateAndSetPropertyValue(Object bean, BeanContext beanContext, BeanId targetBeanId, ExecutionContext executionContext, Fragment source) {
        BeanRuntimeInfo wiredBeanRI = this.getWiredBeanRuntimeInfo();
        if (wiredBeanRI != null && wiredBeanRI.getClassification() == BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Registering bean CHANGE wiring observer for wiring bean '" + targetBeanId + "' onto target bean '" + this.beanId.getName() + "' after it has been converted from a List to an array."));
            }
            beanContext.addObserver((BeanContextLifecycleObserver)this.listToArrayChangeObserver);
        } else {
            this.setPropertyValue(this.property, bean, executionContext, source);
        }
    }

    private void bindExpressionValue(String mapPropertyName, String dataString, ExecutionContext executionContext, Fragment source) {
        Map beanMap = executionContext.getBeanContext().getBeanMap();
        HashMap<String, String> variables = new HashMap<String, String>();
        if (this.expressionHasDataVariable) {
            variables.put(EXPRESSION_VALUE_VARIABLE_NAME, dataString);
        }
        Object dataObject = this.expressionEvaluator.exec((Object)beanMap, variables);
        this.decodeAndSetPropertyValue(mapPropertyName, dataObject, executionContext, source);
    }

    private void decodeAndSetPropertyValue(String mapPropertyName, Object dataObject, ExecutionContext executionContext, Fragment source) {
        if (dataObject instanceof String) {
            this.setPropertyValue(mapPropertyName, this.decodeDataString((String)dataObject, executionContext), executionContext, source);
        } else {
            this.setPropertyValue(mapPropertyName, dataObject, executionContext, source);
        }
    }

    public void setPropertyValue(String mapPropertyName, Object dataObject, ExecutionContext executionContext, Fragment source) {
        if (dataObject == null) {
            return;
        }
        Object bean = executionContext.getBeanContext().getBean(this.beanId);
        BeanRuntimeInfo.Classification beanType = this.beanRuntimeInfo.getClassification();
        this.createPropertySetterMethod(bean, dataObject.getClass());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting data object '" + this.wireBeanIdName + "' (" + dataObject.getClass().getName() + ") on target bean '" + this.beanId + "'."));
        }
        try {
            if (this.propertySetterMethod != null) {
                this.propertySetterMethod.invoke(bean, dataObject);
            } else if (beanType == BeanRuntimeInfo.Classification.MAP_COLLECTION) {
                ((Map)bean).put(mapPropertyName, dataObject);
            } else if (beanType == BeanRuntimeInfo.Classification.ARRAY_COLLECTION || beanType == BeanRuntimeInfo.Classification.COLLECTION_COLLECTION) {
                ((Collection)bean).add(dataObject);
            } else if (this.propertySetterMethod == null) {
                if (this.setterMethod != null) {
                    throw new SmooksConfigurationException("Bean [" + this.beanIdName + "] configuration invalid.  Bean setter method [" + this.setterMethod + "(" + dataObject.getClass().getName() + ")] not found on type [" + this.beanRuntimeInfo.getPopulateType().getName() + "].  You may need to set a 'decoder' on the binding config.");
                }
                if (this.property != null) {
                    throw new SmooksConfigurationException("Bean [" + this.beanIdName + "] configuration invalid.  Bean setter method [" + ClassUtil.toSetterName((String)this.property) + "(" + dataObject.getClass().getName() + ")] not found on type [" + this.beanRuntimeInfo.getPopulateType().getName() + "].  You may need to set a 'decoder' on the binding config.");
                }
            }
            if (this.notifyPopulate) {
                BeanContextLifecycleEvent event = new BeanContextLifecycleEvent(executionContext, source, BeanLifecycle.POPULATE, this.beanId, bean);
                executionContext.getBeanContext().notifyObservers(event);
            }
        }
        catch (IllegalAccessException e) {
            throw new SmooksConfigurationException("Error invoking bean setter method [" + ClassUtil.toSetterName((String)this.property) + "] on bean instance class type [" + bean.getClass() + "].", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new SmooksConfigurationException("Error invoking bean setter method [" + ClassUtil.toSetterName((String)this.property) + "] on bean instance class type [" + bean.getClass() + "].", (Throwable)e);
        }
    }

    private void createPropertySetterMethod(Object bean, Class<?> parameter) {
        if (!this.checkedForSetterMethod && this.propertySetterMethod == null) {
            String methodName = null;
            if (this.setterMethod != null && !this.setterMethod.trim().equals("")) {
                methodName = this.setterMethod;
            } else if (this.property != null && !this.property.trim().equals("")) {
                methodName = ClassUtil.toSetterName((String)this.property);
            }
            if (methodName != null) {
                this.propertySetterMethod = this.createPropertySetterMethod(bean, methodName, parameter);
            }
            this.checkedForSetterMethod = true;
        }
    }

    private synchronized Method createPropertySetterMethod(Object bean, String setterName, Class<?> setterParamType) {
        if (this.propertySetterMethod == null) {
            this.propertySetterMethod = BeanUtils.createSetterMethod(setterName, bean, setterParamType);
        }
        return this.propertySetterMethod;
    }

    private Object decodeDataString(String dataString, ExecutionContext executionContext) throws DataDecodeException {
        if ((dataString == null || dataString.length() == 0) && this.defaultVal != null) {
            if (this.defaultVal.equals("null")) {
                return null;
            }
            dataString = this.defaultVal;
        }
        if (this.decoder == null) {
            this.decoder = this.getDecoder(executionContext);
        }
        try {
            return this.decoder.decode(dataString);
        }
        catch (DataDecodeException e) {
            throw new DataDecodeException("Failed to decode binding value '" + dataString + "' for property '" + this.property + "' on bean '" + this.beanId.getName() + "'.", (Throwable)e);
        }
    }

    private DataDecoder getDecoder(ExecutionContext executionContext) throws DataDecodeException {
        PreprocessDecoder preprocessDecoder;
        List decoders = executionContext.getDeliveryConfig().getObjects("decoder:" + this.typeAlias);
        if (decoders == null || decoders.isEmpty()) {
            this.decoder = this.typeAlias != null ? DataDecoder.Factory.create((String)this.typeAlias) : this.resolveDecoderReflectively();
        } else {
            if (!(decoders.get(0) instanceof DataDecoder)) {
                throw new DataDecodeException("Configured decoder '" + this.typeAlias + ":" + decoders.get(0).getClass().getName() + "' is not an instance of " + DataDecoder.class.getName());
            }
            this.decoder = (DataDecoder)decoders.get(0);
        }
        if (this.decoder instanceof PreprocessDecoder && (preprocessDecoder = (PreprocessDecoder)this.decoder).getBaseDecoder() == null) {
            preprocessDecoder.setBaseDecoder(this.resolveDecoderReflectively());
        }
        return this.decoder;
    }

    private DataDecoder resolveDecoderReflectively() throws DataDecodeException {
        DataDecoder resolvedDecoder;
        Class<?> bindType = this.resolveBindTypeReflectively();
        if (bindType != null && (resolvedDecoder = DataDecoder.Factory.create(bindType)) != null) {
            return resolvedDecoder;
        }
        return new StringDecoder();
    }

    private Class<?> resolveBindTypeReflectively() throws DataDecodeException {
        Method bindingMethod;
        String bindingMember;
        String string = bindingMember = this.setterMethod != null ? this.setterMethod : this.property;
        if (bindingMember != null && this.beanRuntimeInfo.getClassification() == BeanRuntimeInfo.Classification.NON_COLLECTION && (bindingMethod = Bean.getBindingMethod(bindingMember, this.beanRuntimeInfo.getPopulateType())) != null) {
            return bindingMethod.getParameterTypes()[0];
        }
        return null;
    }

    private BeanRuntimeInfo getWiredBeanRuntimeInfo() {
        if (this.wiredBeanRuntimeInfo == null) {
            this.wiredBeanRuntimeInfo = BeanRuntimeInfo.getBeanRuntimeInfo(this.wireBeanIdName, this.appContext);
        }
        return this.wiredBeanRuntimeInfo;
    }

    private String getId() {
        return this.id;
    }

    public Set<? extends Object> getProducts() {
        return CollectionsUtil.toSet((Object[])new String[]{this.beanIdName + "." + this.property, "]." + this.property});
    }

    public boolean consumes(Object object) {
        if (object.equals(this.beanIdName)) {
            return true;
        }
        if (this.wireBeanIdName != null && object.equals(this.wireBeanIdName)) {
            return true;
        }
        return this.expressionEvaluator != null && this.expressionEvaluator.getExpression().indexOf(object.toString()) != -1;
    }
}

