/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ExecutionContext;

public abstract class DocType {
    private static final String DOCTYPE_KEY = DocType.class.getName() + "#DOCTYPE_KEY";

    public static void setDocType(String name, String publicId, String systemId, String xmlns, ExecutionContext executionContext) {
        executionContext.setAttribute(DOCTYPE_KEY, new DocumentTypeData(name, publicId, systemId, xmlns));
    }

    public static DocumentTypeData getDocType(ExecutionContext executionContext) {
        List<SmooksResourceConfiguration> docTypeUDs = executionContext.getDeliveryConfig().getSmooksResourceConfigurations("doctype");
        SmooksResourceConfiguration docTypeSmooksResourceConfiguration = null;
        if (docTypeUDs != null && docTypeUDs.size() > 0) {
            docTypeSmooksResourceConfiguration = docTypeUDs.get(0);
        }
        if (docTypeSmooksResourceConfiguration != null && docTypeSmooksResourceConfiguration.getBoolParameter("override", true)) {
            String name = docTypeSmooksResourceConfiguration.getStringParameter("name", "!!DOCTYPE name undefined - fix smooks-resource!!");
            String publicId = docTypeSmooksResourceConfiguration.getStringParameter("publicId", "!!DOCTYPE publicId undefined - fix smooks-resource!!");
            String systemId = docTypeSmooksResourceConfiguration.getStringParameter("systemId", "!!DOCTYPE systemId undefined - fix smooks-resource!!");
            String xmlns = docTypeSmooksResourceConfiguration.getStringParameter("xmlns");
            boolean omit = docTypeSmooksResourceConfiguration.getBoolParameter("omit", false);
            return new DocumentTypeData(name, publicId, systemId, xmlns, omit);
        }
        return (DocumentTypeData)executionContext.getAttribute(DOCTYPE_KEY);
    }

    public static void serializeDoctype(DocumentTypeData docTypeData, Writer writer) throws IOException {
        if (docTypeData != null && !docTypeData.omit) {
            writer.write("<?xml version='1.0'?>\n");
            writer.write("<!DOCTYPE ");
            writer.write(docTypeData.getName());
            writer.write(32);
            if (docTypeData.getPublicId() != null) {
                writer.write("PUBLIC \"");
                writer.write(docTypeData.getPublicId());
                writer.write("\" ");
            }
            if (docTypeData.getSystemId() != null) {
                writer.write(34);
                writer.write(docTypeData.getSystemId());
                writer.write(34);
            }
            writer.write(62);
            writer.write(10);
        }
    }

    public static class DocumentTypeData {
        private String name;
        private String publicId;
        private String systemId;
        private String xmlns;
        private boolean omit = false;

        public DocumentTypeData(String name, String publicId, String systemId, String xmlns) {
            this.name = name;
            this.publicId = publicId;
            this.systemId = systemId;
            this.xmlns = xmlns;
        }

        public DocumentTypeData(String name, String publicId, String systemId, String xmlns, boolean omit) {
            this(name, publicId, systemId, xmlns);
            this.omit = omit;
        }

        public String getName() {
            return this.name;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public String getXmlns() {
            return this.xmlns;
        }

        public void setXmlns(String xmlns) {
            this.xmlns = xmlns;
        }
    }
}

