/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.templating.xslt;

import java.util.Hashtable;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xalan.extensions.XSLProcessorContext;
import org.apache.xalan.templates.AVT;
import org.apache.xalan.templates.ElemExtensionCall;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Filter;

public class XalanJavabeanExtension {
    private static Log logger = LogFactory.getLog(XalanJavabeanExtension.class);
    private static Hashtable<String, Object> expressionCache = new Hashtable();

    public Object select(XSLProcessorContext context, ElemExtensionCall element) throws OgnlException {
        AVT ognlAVT = element.getLiteralResultAttribute("ognl");
        if (ognlAVT == null) {
            throw new OgnlException("'ognl' expression attribute not specified.");
        }
        return this.select(ognlAVT.getSimpleString());
    }

    public Object select(String ognlExpression) throws OgnlException {
        if (ognlExpression == null || (ognlExpression = ognlExpression.trim()).equals("")) {
            throw new OgnlException("'ognl' expression not specified, or is blank.");
        }
        ExecutionContext activeRequest = Filter.getCurrentExecutionContext();
        if (activeRequest == null) {
            String message = this.getClass().getName() + " can only be used within the context of a SmooksDOMFilter operation..";
            logger.error((Object)message);
            throw new IllegalStateException(message);
        }
        Map<String, Object> beans = activeRequest.getBeanContext().getBeanMap();
        Object parsedExpression = expressionCache.get(ognlExpression);
        if (parsedExpression == null) {
            try {
                parsedExpression = Ognl.parseExpression((String)ognlExpression);
                expressionCache.put(ognlExpression, parsedExpression);
            }
            catch (OgnlException e) {
                logger.error((Object)("Exception parsing OGNL expression [" + ognlExpression + "].  Make sure the expression is properly constructed (http://www.ognl.org)."), (Throwable)e);
                throw e;
            }
        }
        try {
            return Ognl.getValue((Object)parsedExpression, beans);
        }
        catch (OgnlException e) {
            logger.error((Object)("Unexpected exception using OGNL expression [" + ognlExpression + "] on Smooks Javabean cache."), (Throwable)e);
            throw e;
        }
    }
}

