/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.binding.model;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksResourceConfigurationList;
import org.milyn.cdr.xpath.SelectorStep;
import org.milyn.cdr.xpath.SelectorStepBuilder;
import org.milyn.container.ApplicationContext;
import org.milyn.javabean.BeanInstanceCreator;
import org.milyn.javabean.BeanInstancePopulator;
import org.milyn.javabean.DataDecoder;
import org.milyn.javabean.binding.model.Bean;
import org.milyn.javabean.binding.model.Binding;
import org.milyn.javabean.binding.model.DataBinding;
import org.milyn.javabean.binding.model.WiredBinding;
import org.milyn.util.DollarBraceDecoder;
import org.milyn.xml.NamespaceMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelSet {
    private Map<String, Bean> baseBeans = new LinkedHashMap<String, Bean>();
    private Map<String, Bean> models = new LinkedHashMap<String, Bean>();
    private Boolean isBindingOnlyConfig;

    private ModelSet(SmooksResourceConfigurationList userConfigList) throws SmooksConfigurationException {
        this.createBaseBeanMap(userConfigList);
        this.createExpandedModels();
        this.resolveModelSelectors(userConfigList);
    }

    public Bean getModel(String beanId) {
        return this.models.get(beanId);
    }

    public Bean getModel(Class<?> beanType) {
        for (Bean model : this.models.values()) {
            if (model.getCreator().getBeanRuntimeInfo().getPopulateType() != beanType) continue;
            return model;
        }
        return null;
    }

    public Map<String, Bean> getModels() {
        return this.models;
    }

    public boolean isBindingOnlyConfig() {
        return this.isBindingOnlyConfig;
    }

    private void createBaseBeanMap(SmooksResourceConfigurationList userConfigList) {
        for (int i = 0; i < userConfigList.size(); ++i) {
            Bean bean;
            SmooksResourceConfiguration config = userConfigList.get(i);
            Object javaResource = config.getJavaResourceObject();
            if (javaResource instanceof BeanInstanceCreator) {
                BeanInstanceCreator beanCreator = (BeanInstanceCreator)javaResource;
                bean = new Bean(beanCreator).setCloneable(true);
                this.baseBeans.put(bean.getBeanId(), bean);
                if (this.isBindingOnlyConfig != null) continue;
                this.isBindingOnlyConfig = true;
                continue;
            }
            if (javaResource instanceof BeanInstancePopulator) {
                BeanInstancePopulator beanPopulator = (BeanInstancePopulator)javaResource;
                bean = this.baseBeans.get(beanPopulator.getBeanId());
                if (bean == null) {
                    throw new SmooksConfigurationException("Unexpected binding configuration exception.  Unknown parent beanId '' for binding configuration.");
                }
                if (beanPopulator.isBeanWiring()) {
                    bean.getBindings().add(new WiredBinding(beanPopulator));
                    continue;
                }
                bean.getBindings().add(new DataBinding(beanPopulator));
                continue;
            }
            if (!this.isNonBindingResource(javaResource) || this.isGlobalParamsConfig(config)) continue;
            this.isBindingOnlyConfig = false;
        }
    }

    private boolean isNonBindingResource(Object javaResource) {
        if (javaResource instanceof DataDecoder) {
            return false;
        }
        return !(javaResource instanceof NamespaceMappings);
    }

    private boolean isGlobalParamsConfig(SmooksResourceConfiguration config) {
        return "global-parameters".equals(config.getSelector());
    }

    private void createExpandedModels() {
        for (Bean bean : this.baseBeans.values()) {
            this.models.put(bean.getBeanId(), bean.clone(this.baseBeans, null));
        }
    }

    private void resolveModelSelectors(SmooksResourceConfigurationList userConfigList) {
        for (Bean model : this.models.values()) {
            this.resolveModelSelectors(model);
        }
        for (int i = 0; i < userConfigList.size(); ++i) {
            this.expandSelector(userConfigList.get(i), false, null);
        }
    }

    private void resolveModelSelectors(Bean model) {
        SmooksResourceConfiguration beanConfig = model.getConfig();
        this.expandSelector(beanConfig, true, null);
        for (Binding binding : model.getBindings()) {
            SmooksResourceConfiguration bindingConfig = binding.getConfig();
            this.expandSelector(bindingConfig, true, beanConfig);
            if (!(binding instanceof WiredBinding)) continue;
            this.resolveModelSelectors(((WiredBinding)binding).getWiredBean());
        }
    }

    private void expandSelector(SmooksResourceConfiguration resourceConfiguration, boolean failOnMissingBean, SmooksResourceConfiguration context) {
        SelectorStep[] selectorSteps = resourceConfiguration.getSelectorSteps();
        QName targetElement = selectorSteps[0].getTargetElement();
        if (targetElement == null) {
            return;
        }
        String localPart = targetElement.getLocalPart();
        if (localPart.equals("#") && context != null) {
            resourceConfiguration.setSelectorSteps(this.concat(context.getSelectorSteps(), selectorSteps));
            return;
        }
        List<String> dollarBraceTokens = DollarBraceDecoder.getTokens(localPart);
        if (dollarBraceTokens.size() == 1) {
            String beanId = dollarBraceTokens.get(0);
            Bean bean = this.baseBeans.get(beanId);
            if (bean != null) {
                resourceConfiguration.setSelectorSteps(this.concat(bean.getConfig().getSelectorSteps(), selectorSteps));
            } else if (failOnMissingBean) {
                throw new SmooksConfigurationException("Invalid selector '" + SelectorStepBuilder.toString(selectorSteps) + "'.  Unknown beanId '" + beanId + "'.");
            }
        }
    }

    private SelectorStep[] concat(SelectorStep[] context, SelectorStep[] beanSelectorSteps) {
        SelectorStep[] newSteps = new SelectorStep[context.length + beanSelectorSteps.length - 1];
        System.arraycopy(context, 0, newSteps, 0, context.length);
        System.arraycopy(beanSelectorSteps, 1, newSteps, context.length, beanSelectorSteps.length - 1);
        return newSteps;
    }

    public static void build(ApplicationContext appContext) {
        ModelSet modelSet = ModelSet.get(appContext);
        if (modelSet == null) {
            modelSet = new ModelSet(appContext.getStore().getUserDefinedResourceList());
            appContext.setAttribute(ModelSet.class, modelSet);
        }
    }

    public static ModelSet get(ApplicationContext appContext) {
        return (ModelSet)appContext.getAttribute(ModelSet.class);
    }
}

