/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.classpath;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;

public class CascadingClassLoaderSet
extends ClassLoader {
    List<ClassLoader> classLoaders = new ArrayList<ClassLoader>();
    private int classLoaderCount;

    public CascadingClassLoaderSet addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
        this.classLoaderCount = this.classLoaders.size();
        return this;
    }

    @Override
    public Class<?> loadClass(String s) throws ClassNotFoundException {
        for (int i = 0; i < this.classLoaderCount; ++i) {
            ClassLoader classLoader = this.classLoaders.get(i);
            try {
                Class<?> klass = classLoader.loadClass(s);
                if (klass == null) continue;
                return klass;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException("Failed to find class '" + s + "'.");
    }

    @Override
    public URL getResource(String s) {
        for (int i = 0; i < this.classLoaderCount; ++i) {
            ClassLoader classLoader = this.classLoaders.get(i);
            URL resource = classLoader.getResource(s);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String s) throws IOException {
        ArrayList<URL> resources = new ArrayList<URL>();
        for (int i = 0; i < this.classLoaderCount; ++i) {
            ClassLoader classLoader = this.classLoaders.get(i);
            Enumeration<URL> resourcesEnum = classLoader.getResources(s);
            if (!resourcesEnum.hasMoreElements()) continue;
            resources.addAll(Collections.list(resourcesEnum));
        }
        return Collections.enumeration(resources);
    }

    @Override
    public InputStream getResourceAsStream(String s) {
        for (int i = 0; i < this.classLoaderCount; ++i) {
            ClassLoader classLoader = this.classLoaders.get(i);
            InputStream resource = classLoader.getResourceAsStream(s);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }
}

