/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.smooks.edi.unedifact;

import java.io.IOException;
import java.util.Map;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.edisax.BufferedSegmentReader;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.interchange.ControlBlockHandlerFactory;
import org.milyn.edisax.interchange.InterchangeContext;
import org.milyn.edisax.model.EdifactModel;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.unedifact.UNEdifactInterchangeParser;
import org.milyn.smooks.edi.ModelLoader;
import org.milyn.xml.SmooksXMLReader;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class UNEdifactReader
extends UNEdifactInterchangeParser
implements SmooksXMLReader {
    @ConfigParam
    private String mappingModel;
    @ConfigParam(defaultVal="false")
    private boolean validate;
    @ConfigParam(defaultVal="false")
    private boolean ignoreNewLines;
    @AppContext
    private ApplicationContext applicationContext;
    private ExecutionContext executionContext;

    public void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }

    public void parse(InputSource unedifactInterchange) throws IOException, SAXException {
        Map<Description, EdifactModel> mappingModelMap;
        try {
            mappingModelMap = ModelLoader.getMappingModels(this.mappingModel, this.applicationContext);
        }
        catch (EDIConfigurationException e) {
            throw (IOException)new IOException("Failed to load mapping model(s) '" + this.mappingModel + "'.").initCause(e);
        }
        this.setMappingModels(mappingModelMap);
        this.ignoreNewLines(this.ignoreNewLines);
        this.validate(this.validate);
        super.parse(unedifactInterchange);
    }

    protected InterchangeContext createInterchangeContext(BufferedSegmentReader segmentReader, boolean validate, ControlBlockHandlerFactory controlBlockHandlerFactory) {
        return new InterchangeContext(segmentReader, this.getMappingModels(), this.getContentHandler(), controlBlockHandlerFactory, validate){

            public void pushDelimiters(Delimiters delimiters) {
                super.pushDelimiters(delimiters);
                UNEdifactReader.this.executionContext.getBeanContext().addBean("interchangeDelimiters", (Object)delimiters);
            }
        };
    }
}

