/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.unedifact.handlers.r41;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.edisax.BufferedSegmentReader;
import org.milyn.edisax.EDIParseException;
import org.milyn.edisax.interchange.ControlBlockHandler;
import org.milyn.edisax.interchange.InterchangeContext;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.util.EDIUtils;
import org.xml.sax.SAXException;

class UNBHandler
implements ControlBlockHandler {
    private static Log logger = LogFactory.getLog(UNBHandler.class);
    private static Segment unbSegment;
    private static Segment unzSegment;
    private static Map<String, Charset> toCharsetMapping;

    UNBHandler() {
    }

    public void process(InterchangeContext interchangeContext) throws IOException, SAXException {
        BufferedSegmentReader segmentReader = interchangeContext.getSegmentReader();
        segmentReader.moveToNextSegment(false);
        String[] fields = segmentReader.getCurrentSegmentFields();
        interchangeContext.mapControlSegment(unbSegment, true);
        String[] syntaxIdComponents = EDIUtils.split(fields[1], segmentReader.getDelimiters().getComponent(), segmentReader.getDelimiters().getEscape());
        if (syntaxIdComponents.length < 4) {
            this.changeReadEncoding(syntaxIdComponents[0], interchangeContext.getSegmentReader());
        } else {
            this.changeReadEncoding(syntaxIdComponents[3], interchangeContext.getSegmentReader());
        }
        while (true) {
            String segCode;
            if ((segCode = segmentReader.peek(3)).equals("UNZ")) break;
            ControlBlockHandler handler = interchangeContext.getControlBlockHandler(segCode);
            handler.process(interchangeContext);
        }
        segmentReader.moveToNextSegment(false);
        interchangeContext.mapControlSegment(unzSegment, true);
    }

    private void changeReadEncoding(String code, BufferedSegmentReader bufferedSegmentReader) throws EDIParseException, IOException {
        Charset charset = toCharsetMapping.get(code.toUpperCase());
        if (charset == null) {
            throw new EDIParseException("Unknown UN/EDIFACT character stream encoding code '" + code + "'.");
        }
        bufferedSegmentReader.changeEncoding(charset);
    }

    private static void createSegmentsDefs() {
        unbSegment = new Segment();
        unbSegment.setSegcode("UNB");
        unbSegment.setXmltag("UNB");
        unbSegment.setDescription("UNB - Interchange Header");
        unbSegment.setTruncatable(true);
        unbSegment.addField(new Field("syntaxIdentifier", true).addComponent(new Component("id", true)).addComponent(new Component("versionNum", true)).addComponent(new Component("serviceCodeListDirVersion", false)).addComponent(new Component("codedCharacterEncoding", false)).addComponent(new Component("releaseNum", false)));
        unbSegment.addField(new Field("sender", true).addComponent(new Component("id", true)).addComponent(new Component("codeQualifier", false)).addComponent(new Component("internalId", false)).addComponent(new Component("internalSubId", false)));
        unbSegment.addField(new Field("recipient", true).addComponent(new Component("id", true)).addComponent(new Component("codeQualifier", false)).addComponent(new Component("internalId", false)).addComponent(new Component("internalSubId", false)));
        unbSegment.addField(new Field("dateTime", true).addComponent(new Component("date", true)).addComponent(new Component("time", true)));
        unbSegment.addField(new Field("controlRef", true));
        unbSegment.addField(new Field("recipientRef", false).addComponent(new Component("ref", true)).addComponent(new Component("refQualifier", false)));
        unbSegment.addField(new Field("applicationRef", false));
        unbSegment.addField(new Field("processingPriorityCode", false));
        unbSegment.addField(new Field("ackRequest", false));
        unbSegment.addField(new Field("agreementId", false));
        unbSegment.addField(new Field("testIndicator", false));
        unzSegment = new Segment();
        unzSegment.setSegcode("UNZ");
        unzSegment.setXmltag("UNZ");
        unzSegment.setDescription("UNZ - Interchange Trailer");
        unzSegment.setTruncatable(true);
        unzSegment.addField(new Field("controlCount", true));
        unzSegment.addField(new Field("controlRef", true));
    }

    private static void createRepertoireToCharsetMap() {
        toCharsetMapping = new HashMap<String, Charset>();
        UNBHandler.addCharsetMapping("UNOA", "ASCII");
        UNBHandler.addCharsetMapping("UNOB", "ASCII");
        UNBHandler.addCharsetMapping("UNOC", "ISO8859-1");
        UNBHandler.addCharsetMapping("UNOD", "ISO8859-2");
        UNBHandler.addCharsetMapping("UNOE", "ISO8859-5");
        UNBHandler.addCharsetMapping("UNOF", "ISO8859-7");
        UNBHandler.addCharsetMapping("UNOG", "ISO8859-3");
        UNBHandler.addCharsetMapping("UNOH", "ISO8859-4");
        UNBHandler.addCharsetMapping("UNOI", "ISO8859-6");
        UNBHandler.addCharsetMapping("UNOJ", "ISO8859-8");
        UNBHandler.addCharsetMapping("UNOK", "ISO8859-9");
        UNBHandler.addCharsetMapping("UNOL", "ISO8859-15");
        UNBHandler.addCharsetMapping("UNOW", "UTF-8");
        UNBHandler.addCharsetMapping("UNOX", "ISO-2022-CN");
        UNBHandler.addCharsetMapping("UNOY", "UTF-8");
        UNBHandler.addCharsetMapping("1", "ASCII");
        UNBHandler.addCharsetMapping("2", "ASCII");
        UNBHandler.addCharsetMapping("3", "IBM500");
        UNBHandler.addCharsetMapping("4", "IBM850");
        UNBHandler.addCharsetMapping("5", "UTF-16");
        UNBHandler.addCharsetMapping("6", "UTF-32");
        UNBHandler.addCharsetMapping("7", "UTF-8");
        UNBHandler.addCharsetMapping("8", "UTF-16");
    }

    private static void addCharsetMapping(String code, String charsetName) {
        if (Charset.isSupported(charsetName)) {
            toCharsetMapping.put(code, Charset.forName(charsetName));
        } else {
            logger.debug((Object)("Unsupported character set '" + charsetName + "'.  Cannot support for '" + code + "' if defined on the syntaxIdentifier field on the UNB segment.  Check the JVM version etc."));
        }
    }

    static {
        UNBHandler.createSegmentsDefs();
        UNBHandler.createRepertoireToCharsetMap();
    }
}

