/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.milyn.cdr.ConfigSearch;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.cdr.SmooksResourceConfigurationList;
import org.milyn.cdr.XMLConfigDigester;
import org.milyn.container.ExecutionContext;
import org.milyn.expression.ExpressionEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionContext {
    private static final String EXEC_CONTEXT_KEY = ExtensionContext.class.getName() + "#EXEC_CONTEXT_KEY";
    private XMLConfigDigester xmlConfigDigester;
    private String defaultSelector;
    private String defaultNamespace;
    private String defaultProfile;
    private ExpressionEvaluator defaultConditionEvaluator;
    private Stack<SmooksResourceConfiguration> resourceStack = new Stack();
    private List<SmooksResourceConfiguration> resources = new ArrayList<SmooksResourceConfiguration>();

    public ExtensionContext(XMLConfigDigester xmlConfigDigester, String defaultSelector, String defaultNamespace, String defaultProfile, ExpressionEvaluator defaultConditionEvaluator) {
        this.xmlConfigDigester = xmlConfigDigester;
        this.defaultSelector = defaultSelector;
        this.defaultNamespace = defaultNamespace;
        this.defaultProfile = defaultProfile;
        this.defaultConditionEvaluator = defaultConditionEvaluator;
    }

    public static void setExtensionContext(ExtensionContext extensionContext, ExecutionContext executionContext) {
        executionContext.setAttribute(EXEC_CONTEXT_KEY, extensionContext);
    }

    public static ExtensionContext getExtensionContext(ExecutionContext executionContext) {
        return (ExtensionContext)executionContext.getAttribute(EXEC_CONTEXT_KEY);
    }

    public void addResource(SmooksResourceConfiguration resource) {
        this.resourceStack.push(resource);
        this.resources.add(resource);
    }

    public void addResourceTemplate(SmooksResourceConfiguration resource) {
        this.resourceStack.push(resource);
    }

    public Stack<SmooksResourceConfiguration> getResourceStack() {
        return this.resourceStack;
    }

    public List<SmooksResourceConfiguration> getResources() {
        return this.resources;
    }

    public SmooksResourceConfigurationList getResourceList() {
        return this.xmlConfigDigester.getResourceList();
    }

    public SmooksResourceConfiguration getCurrentConfig() {
        if (this.resourceStack.isEmpty()) {
            return null;
        }
        return this.resourceStack.peek();
    }

    public XMLConfigDigester getXmlConfigDigester() {
        return this.xmlConfigDigester;
    }

    public String getDefaultSelector() {
        return this.defaultSelector;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public String getDefaultProfile() {
        return this.defaultProfile;
    }

    public ExpressionEvaluator getDefaultConditionEvaluator() {
        return this.defaultConditionEvaluator;
    }

    public SmooksResourceConfiguration getResourceByName(String name) {
        for (int i = this.resourceStack.size() - 1; i >= 0; --i) {
            SmooksResourceConfiguration config = (SmooksResourceConfiguration)this.resourceStack.get(i);
            String resourceName = config.getResource();
            if (!name.equals(resourceName)) continue;
            return config;
        }
        return null;
    }

    public List<SmooksResourceConfiguration> lookupResource(ConfigSearch searchCriteria) {
        return this.xmlConfigDigester.getResourceList().lookupResource(searchCriteria);
    }
}

