/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.ConfigSearch;
import org.milyn.cdr.ProfileTargetingExpression;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.profile.ProfileSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmooksResourceConfigurationList {
    private static Log logger = LogFactory.getLog(SmooksResourceConfigurationList.class);
    private String name;
    private List<ProfileSet> profiles = new Vector<ProfileSet>();
    private List<SmooksResourceConfiguration> list = new ArrayList<SmooksResourceConfiguration>();
    private List<URI> loadedResources = new ArrayList<URI>();

    public SmooksResourceConfigurationList(String name) {
        if (name == null || (name = name.trim()).equals("")) {
            throw new IllegalArgumentException("null or empty 'name' arg in constructor call.");
        }
        this.name = name;
        logger.debug((Object)("Smooks ResourceConfiguration List [" + name + "] created."));
    }

    public void add(SmooksResourceConfiguration config) {
        String[] selectors;
        AssertArgument.isNotNull(config, "config");
        for (String selector : selectors = config.getSelector().split(",")) {
            SmooksResourceConfiguration clone = (SmooksResourceConfiguration)config.clone();
            clone.setSelector(selector.trim());
            this.list.add(clone);
            logger.debug((Object)("Smooks ResourceConfiguration [" + clone + "] added to list [" + this.name + "]."));
        }
    }

    public void add(ProfileSet profileSet) {
        AssertArgument.isNotNull(profileSet, "profileSet");
        this.profiles.add(profileSet);
        logger.debug((Object)("ProfileSet [" + profileSet.getBaseProfile() + "] added to list Smooks configuration [" + this.name + "]."));
    }

    public String getName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public int size() {
        return this.list.size();
    }

    public SmooksResourceConfiguration get(int index) throws ArrayIndexOutOfBoundsException {
        return this.list.get(index);
    }

    public SmooksResourceConfiguration[] getTargetConfigurations(ProfileSet profileSet) {
        Vector<SmooksResourceConfiguration> matchingSmooksResourceConfigurationsColl = new Vector<SmooksResourceConfiguration>();
        block0: for (int i = 0; i < this.size(); ++i) {
            SmooksResourceConfiguration resourceConfig = this.get(i);
            ProfileTargetingExpression[] profileTargetingExpressions = resourceConfig.getProfileTargetingExpressions();
            for (int expIndex = 0; expIndex < profileTargetingExpressions.length; ++expIndex) {
                ProfileTargetingExpression expression = profileTargetingExpressions[expIndex];
                if (expression.isMatch(profileSet)) {
                    matchingSmooksResourceConfigurationsColl.addElement(resourceConfig);
                    continue block0;
                }
                logger.debug((Object)("Resource [" + resourceConfig + "] not targeted at profile [" + profileSet.getBaseProfile() + "].  Sub Profiles: [" + profileSet + "]"));
            }
        }
        SmooksResourceConfiguration[] matchingSmooksResourceConfigurations = new SmooksResourceConfiguration[matchingSmooksResourceConfigurationsColl.size()];
        matchingSmooksResourceConfigurationsColl.toArray(matchingSmooksResourceConfigurations);
        return matchingSmooksResourceConfigurations;
    }

    public List<ProfileSet> getProfiles() {
        return this.profiles;
    }

    protected boolean addSourceResourceURI(URI resource) {
        AssertArgument.isNotNull(resource, "resource");
        if (this.loadedResources.contains(resource)) {
            URI lastLoaded = this.loadedResources.get(this.loadedResources.size() - 1);
            logger.info((Object)("Not adding resource config import '" + resource + "'.  This resource is already loaded on this list."));
            return false;
        }
        this.loadedResources.add(resource);
        return true;
    }

    public List<SmooksResourceConfiguration> lookupResource(ConfigSearch searchCriteria) {
        ArrayList<SmooksResourceConfiguration> results = new ArrayList<SmooksResourceConfiguration>();
        for (SmooksResourceConfiguration config : this.list) {
            if (!searchCriteria.matches(config)) continue;
            results.add(config);
        }
        return results;
    }
}

