/*
 * Decompiled with CFR 0.152.
 */
package org.milyn;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.milyn.ResourceFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMerger {
    private List<String> resourcePaths = new ArrayList<String>();

    public ResourceMerger(String resourcePath) {
        this.resourcePaths.add(resourcePath);
    }

    public ResourceMerger(List<String> resourcesPaths) {
        this.resourcePaths.addAll(resourcesPaths);
    }

    public JavaArchive mergeJars(String jarname, File ... archives) throws IOException {
        ArrayList<JavaArchive> jars = new ArrayList<JavaArchive>();
        for (File jar : archives) {
            jars.add((JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)jar));
        }
        return this.mergeJars(jarname, jars);
    }

    public JavaArchive mergeJars(String newJarName, List<JavaArchive> archives) throws IOException {
        JavaArchive all = this.getOrCreateJavaArchive(newJarName);
        HashMap<String, List<Node>> pathToNodeMap = new HashMap<String, List<Node>>();
        for (JavaArchive jar : archives) {
            for (String resourcePath : this.resourcePaths) {
                Map content;
                Node node;
                if (!jar.contains(resourcePath) || (node = (Node)(content = jar.getContent((Filter)new ResourceFilter(resourcePath))).get(ArchivePaths.create((String)resourcePath))) == null) continue;
                List<Node> list = this.getNodesForResource(pathToNodeMap, resourcePath);
                list.add(node);
                pathToNodeMap.put(resourcePath, list);
            }
            all.merge((Archive)jar);
        }
        return this.mergeResources(pathToNodeMap, all);
    }

    private JavaArchive getOrCreateJavaArchive(String jarname) {
        File jarfile = new File(jarname);
        return jarfile.exists() ? (JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)jarfile) : (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)jarname);
    }

    private JavaArchive mergeResources(Map<String, List<Node>> pathToNodeMap, JavaArchive jar) throws IOException {
        Set<Map.Entry<String, List<Node>>> entrySet = pathToNodeMap.entrySet();
        for (Map.Entry<String, List<Node>> resourceEntries : entrySet) {
            String resourcePath = resourceEntries.getKey();
            List<Node> nodes = resourceEntries.getValue();
            jar.delete(ArchivePaths.create((String)resourcePath));
            StringWriter stringWriter = new StringWriter();
            for (Node resoureFileNode : nodes) {
                this.append(resoureFileNode.getAsset(), stringWriter);
            }
            jar.addResource((Asset)new StringAsset(stringWriter.toString()), resourcePath);
        }
        return jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void append(Asset asset, StringWriter to) throws IOException {
        BufferedReader in = null;
        try {
            int n;
            in = new BufferedReader(new InputStreamReader(asset.openStream()));
            char[] buffer = new char[1024];
            while ((n = in.read(buffer)) != -1) {
                to.write(buffer, 0, n);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    private List<Node> getNodesForResource(Map<String, List<Node>> map, String resourcePath) {
        List<Node> list = map.get(resourcePath);
        if (list == null) {
            list = new ArrayList<Node>();
        }
        return list;
    }

    public static List<JavaArchive> fromFiles(List<File> jars) {
        ArrayList<JavaArchive> javaArchives = new ArrayList<JavaArchive>();
        for (File jar : jars) {
            javaArchives.add((JavaArchive)ShrinkWrap.createFromZipFile(JavaArchive.class, (File)jar));
        }
        return javaArchives;
    }
}

