/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.milyn.assertion.AssertArgument;
import org.milyn.io.StreamUtils;

public abstract class FileUtils {
    public static void copyFile(String from, String to) throws IOException {
        File fromFile = new File(from);
        File toFile = new File(to);
        FileUtils.writeFile(FileUtils.readFile(fromFile), toFile);
    }

    public static byte[] readFile(File file) throws IOException {
        AssertArgument.isNotNull(file, "file");
        if (!file.exists()) {
            throw new IllegalArgumentException("No such file '" + file.getAbsoluteFile() + "'.");
        }
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File '" + file.getAbsoluteFile() + "' is a directory.  Cannot read.");
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            byte[] byArray = StreamUtils.readStream(stream);
            return byArray;
        }
        finally {
            ((InputStream)stream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(byte[] bytes, File file) throws IOException {
        if (file.isDirectory()) {
            throw new IllegalArgumentException("File '" + file.getAbsoluteFile() + "' is an existing directory.  Cannot write.");
        }
        File folder = file.getParentFile();
        if (folder != null && !folder.exists()) {
            folder.mkdirs();
        }
        FileOutputStream stream = new FileOutputStream(file);
        try {
            stream.write(bytes);
            stream.flush();
        }
        finally {
            stream.close();
        }
    }

    public static boolean deleteDir(File dir) {
        File[] files;
        AssertArgument.isNotNull(dir, "dir");
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("File '" + dir.getAbsolutePath() + "' is not a directory.");
        }
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                FileUtils.deleteDir(file);
                continue;
            }
            file.delete();
        }
        return dir.delete();
    }
}

