/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.ByteProcessor;
import java.nio.charset.StandardCharsets;
import org.mariadb.r2dbc.message.Context;

public final class BufferUtils {
    public static final byte[] BINARY_PREFIX = new byte[]{95, 98, 105, 110, 97, 114, 121, 32, 39};
    public static final byte[] STRING_PREFIX = new byte[]{39};
    private static final byte QUOTE = 39;
    private static final byte ZERO_BYTE = 0;
    private static final byte BACKSLASH = 92;

    public static void skipLengthEncode(ByteBuf buf) {
        short type = buf.readUnsignedByte();
        switch (type) {
            case 252: {
                buf.skipBytes(buf.readUnsignedShortLE());
                return;
            }
            case 253: {
                buf.skipBytes(buf.readUnsignedMediumLE());
                return;
            }
            case 254: {
                buf.skipBytes((int)buf.readLongLE());
                return;
            }
        }
        buf.skipBytes((int)type);
    }

    public static long readLengthEncodedInt(ByteBuf buf) {
        short type = buf.readUnsignedByte();
        switch (type) {
            case 251: {
                return -1L;
            }
            case 252: {
                return buf.readUnsignedShortLE();
            }
            case 253: {
                return buf.readUnsignedMediumLE();
            }
            case 254: {
                return buf.readLongLE();
            }
        }
        return type;
    }

    public static String readLengthEncodedString(ByteBuf buf) {
        int length = (int)BufferUtils.readLengthEncodedInt(buf);
        if (length == -1) {
            return null;
        }
        return buf.readCharSequence(length, StandardCharsets.UTF_8).toString();
    }

    public static ByteBuf readLengthEncodedBuffer(ByteBuf buf) {
        int length = (int)BufferUtils.readLengthEncodedInt(buf);
        if (length == -1) {
            return null;
        }
        buf.skipBytes(length);
        return buf.slice(buf.readerIndex() - length, length);
    }

    public static byte[] encodeLength(int length) {
        if (length < 251) {
            return new byte[]{(byte)length};
        }
        if (length < 65536) {
            return new byte[]{-4, (byte)length, (byte)(length >>> 8)};
        }
        if (length < 0x1000000) {
            return new byte[]{-3, (byte)length, (byte)(length >>> 8), (byte)(length >>> 16)};
        }
        return new byte[]{-2, (byte)length, (byte)(length >>> 8), (byte)(length >>> 16), (byte)(length >>> 24), (byte)(length >>> 32), (byte)(length >>> 40), (byte)(length >>> 48), (byte)(length >>> 54)};
    }

    public static void writeLengthEncode(String val, ByteBuf buf) {
        byte[] bytes = val.getBytes(StandardCharsets.UTF_8);
        buf.writeBytes(BufferUtils.encodeLength(bytes.length));
        buf.writeBytes(bytes);
    }

    public static ByteBuf encodeLengthUtf8(ByteBufAllocator allocator, String value) {
        byte[] b = value.getBytes(StandardCharsets.UTF_8);
        CompositeByteBuf byteBuf = allocator.compositeBuffer();
        byteBuf.addComponent(true, Unpooled.wrappedBuffer((byte[])BufferUtils.encodeLength(b.length)));
        byteBuf.addComponent(true, Unpooled.wrappedBuffer((byte[])b));
        return byteBuf;
    }

    public static ByteBuf encodeEscapedBuffer(ByteBufAllocator allocator, ByteBuf value, Context context) {
        ByteBuf buf = allocator.buffer(value.readableBytes() * 2);
        buf.writeBytes(BINARY_PREFIX);
        boolean noBackslashEscapes = (context.getServerStatus() & 0x200) > 0;
        int fromIndex = value.readerIndex();
        int toIndex = value.writerIndex();
        if (noBackslashEscapes) {
            int nextPos;
            while ((nextPos = value.indexOf(fromIndex, toIndex, (byte)39)) >= 0) {
                buf.writeBytes(value, fromIndex, nextPos - fromIndex);
                buf.writeByte(39);
                buf.writeByte(39);
                fromIndex = nextPos + 1;
            }
            buf.writeBytes(value, fromIndex, toIndex);
        } else {
            ByteProcessor processor = b -> b != 39 && b != 92 && b != 34 && b != 0;
            while (true) {
                int nextPos;
                if ((nextPos = value.forEachByte(fromIndex, toIndex - fromIndex, processor)) == -1) {
                    buf.writeBytes(value, fromIndex, toIndex - fromIndex);
                    break;
                }
                buf.writeBytes(value, fromIndex, nextPos - fromIndex);
                buf.writeByte(92);
                buf.writeByte((int)value.getByte(nextPos));
                fromIndex = nextPos + 1;
            }
        }
        buf.writeByte(39);
        return buf;
    }

    public static ByteBuf encodeEscapedBytes(ByteBufAllocator allocator, byte[] prefix, byte[] value, Context context) {
        ByteBuf stBuf = Unpooled.wrappedBuffer((byte[])value);
        ByteBuf buf = allocator.buffer(stBuf.readableBytes() + 10);
        buf.writeBytes(prefix);
        BufferUtils.escapedBytes(buf, value, value.length, context);
        buf.writeByte(39);
        return buf;
    }

    public static void escapedBytes(ByteBuf buf, byte[] value, int len, Context context) {
        ByteBuf stBuf = Unpooled.wrappedBuffer((byte[])value, (int)0, (int)len);
        boolean noBackslashEscapes = (context.getServerStatus() & 0x200) > 0;
        int fromIndex = stBuf.readerIndex();
        int toIndex = stBuf.writerIndex();
        if (noBackslashEscapes) {
            int nextPos;
            while ((nextPos = stBuf.indexOf(fromIndex, toIndex, (byte)39)) >= 0) {
                buf.writeBytes(stBuf, fromIndex, nextPos - fromIndex);
                buf.writeByte(39);
                buf.writeByte(39);
                fromIndex = nextPos + 1;
            }
            buf.writeBytes(stBuf, fromIndex, toIndex - fromIndex);
        } else {
            ByteProcessor processor = b -> b != 39 && b != 92 && b != 34 && b != 0;
            while (true) {
                int nextPos;
                if ((nextPos = stBuf.forEachByte(fromIndex, toIndex - fromIndex, processor)) == -1) {
                    buf.writeBytes(stBuf, fromIndex, toIndex - fromIndex);
                    break;
                }
                buf.writeBytes(stBuf, fromIndex, nextPos - fromIndex);
                buf.writeByte(92);
                buf.writeByte((int)stBuf.getByte(nextPos));
                fromIndex = nextPos + 1;
            }
        }
    }

    public static String toString(ByteBuf packet) {
        char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[packet.readableBytes() * 2];
        int j = 0;
        while (packet.readableBytes() > 0) {
            int v = packet.readByte() & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }
}

