/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

public class ServerVersion {
    public static final ServerVersion UNKNOWN_VERSION = new ServerVersion("0.0.0", true);
    private final String serverVersion;
    private final int majorVersion;
    private final int minorVersion;
    private final int patchVersion;
    private final boolean mariaDBServer;
    private final boolean supportReturning;

    public ServerVersion(String serverVersion, boolean mariaDBServer) {
        this.serverVersion = serverVersion;
        this.mariaDBServer = mariaDBServer;
        int[] parsed = this.parseVersion(serverVersion);
        this.majorVersion = parsed[0];
        this.minorVersion = parsed[1];
        this.patchVersion = parsed[2];
        this.supportReturning = mariaDBServer && this.versionGreaterOrEqual(10, 5, 1);
    }

    public boolean isMariaDBServer() {
        return this.mariaDBServer;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }

    public boolean supportReturning() {
        return this.supportReturning;
    }

    public boolean versionGreaterOrEqual(int major, int minor, int patch) {
        if (this.majorVersion > major) {
            return true;
        }
        if (this.majorVersion < major) {
            return false;
        }
        if (this.minorVersion > minor) {
            return true;
        }
        if (this.minorVersion < minor) {
            return false;
        }
        return this.patchVersion >= patch;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int[] parseVersion(String serverVersion) {
        int length = serverVersion.length();
        int type = 0;
        int val = 0;
        int majorVersion = 0;
        int minorVersion = 0;
        int patchVersion = 0;
        block5: for (int offset = 0; offset < length; ++offset) {
            char car = serverVersion.charAt(offset);
            if (car < '0' || car > '9') {
                switch (type) {
                    case 0: {
                        majorVersion = val;
                        break;
                    }
                    case 1: {
                        minorVersion = val;
                        break;
                    }
                    case 2: {
                        patchVersion = val;
                        break block5;
                    }
                }
                ++type;
                val = 0;
                continue;
            }
            val = val * 10 + car - 48;
        }
        if (type == 2) {
            patchVersion = val;
        }
        return new int[]{majorVersion, minorVersion, patchVersion};
    }

    public String toString() {
        return "ServerVersion{" + this.serverVersion + '}';
    }
}

