/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.client.context;

import java.util.function.Function;
import org.mariadb.jdbc.Configuration;
import org.mariadb.jdbc.HostAddress;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.PrepareCache;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.ServerVersion;
import org.mariadb.jdbc.export.ExceptionFactory;
import org.mariadb.jdbc.message.server.InitialHandshakePacket;

public class BaseContext
implements Context {
    private final long serverCapabilities;
    private final long clientCapabilities;
    private final byte[] seed;
    private final ServerVersion version;
    private final boolean eofDeprecated;
    private final boolean skipMeta;
    private final Function<ReadableByteBuf, ColumnDecoder> columnDecoderFunction;
    private final Configuration conf;
    private final ExceptionFactory exceptionFactory;
    private final PrepareCache prepareCache;
    private final HostAddress hostAddress;
    protected int serverStatus;
    private long threadId;
    private String charset;
    private String database;
    private Integer transactionIsolationLevel;
    private int warning;
    private int stateFlag = 0;

    public BaseContext(HostAddress hostAddress, InitialHandshakePacket handshake, long clientCapabilities, Configuration conf, ExceptionFactory exceptionFactory, PrepareCache prepareCache) {
        this.hostAddress = hostAddress;
        this.threadId = handshake.getThreadId();
        this.seed = handshake.getSeed();
        this.serverCapabilities = handshake.getCapabilities();
        this.serverStatus = handshake.getServerStatus();
        this.version = handshake.getVersion();
        this.clientCapabilities = clientCapabilities;
        this.eofDeprecated = this.hasClientCapability(0x1000000L);
        this.skipMeta = this.hasClientCapability(0x1000000000L);
        this.columnDecoderFunction = this.hasClientCapability(0x800000000L) ? ColumnDecoder::decode : ColumnDecoder::decodeStd;
        this.conf = conf;
        this.database = conf.database();
        this.exceptionFactory = exceptionFactory;
        this.prepareCache = prepareCache;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public void setThreadId(long connectionId) {
        this.threadId = connectionId;
    }

    @Override
    public byte[] getSeed() {
        return this.seed;
    }

    @Override
    public boolean hasServerCapability(long flag) {
        return (this.serverCapabilities & flag) > 0L;
    }

    @Override
    public boolean hasClientCapability(long flag) {
        return (this.clientCapabilities & flag) > 0L;
    }

    @Override
    public boolean permitPipeline() {
        return !this.conf.disablePipeline() && (this.clientCapabilities & 0x400000000L) > 0L;
    }

    @Override
    public int getServerStatus() {
        return this.serverStatus;
    }

    @Override
    public void setServerStatus(int serverStatus) {
        this.serverStatus = serverStatus;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public ServerVersion getVersion() {
        return this.version;
    }

    @Override
    public boolean isEofDeprecated() {
        return this.eofDeprecated;
    }

    @Override
    public Function<ReadableByteBuf, ColumnDecoder> getColumnDecoderFunction() {
        return this.columnDecoderFunction;
    }

    @Override
    public boolean canSkipMeta() {
        return this.skipMeta;
    }

    @Override
    public int getWarning() {
        return this.warning;
    }

    @Override
    public void setWarning(int warning) {
        this.warning = warning;
    }

    @Override
    public ExceptionFactory getExceptionFactory() {
        return this.exceptionFactory;
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public Integer getTransactionIsolationLevel() {
        return this.transactionIsolationLevel;
    }

    @Override
    public void setTransactionIsolationLevel(int transactionIsolationLevel) {
        this.transactionIsolationLevel = transactionIsolationLevel;
    }

    @Override
    public PrepareCache getPrepareCache() {
        return this.prepareCache;
    }

    @Override
    public void resetPrepareCache() {
        if (this.prepareCache != null) {
            this.prepareCache.reset();
        }
    }

    @Override
    public int getStateFlag() {
        return this.stateFlag;
    }

    @Override
    public void resetStateFlag() {
        this.stateFlag = 0;
    }

    @Override
    public void addStateFlag(int state) {
        this.stateFlag |= state;
    }

    @Override
    public void setTreadsConnected(long threadsConnected) {
        if (this.hostAddress != null) {
            this.hostAddress.setThreadsConnected(threadsConnected);
        }
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }
}

