/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.plugin.codec;

import java.io.IOException;
import java.sql.SQLDataException;
import java.util.Calendar;
import java.util.EnumSet;
import org.mariadb.jdbc.client.ColumnDecoder;
import org.mariadb.jdbc.client.Context;
import org.mariadb.jdbc.client.DataType;
import org.mariadb.jdbc.client.ReadableByteBuf;
import org.mariadb.jdbc.client.socket.Writer;
import org.mariadb.jdbc.plugin.Codec;

public class ByteCodec
implements Codec<Byte> {
    public static final ByteCodec INSTANCE = new ByteCodec();
    private static final EnumSet<DataType> COMPATIBLE_TYPES = EnumSet.of(DataType.TINYINT, new DataType[]{DataType.SMALLINT, DataType.MEDIUMINT, DataType.INTEGER, DataType.BIGINT, DataType.YEAR, DataType.BIT, DataType.FLOAT, DataType.DOUBLE, DataType.OLDDECIMAL, DataType.BLOB, DataType.TINYBLOB, DataType.MEDIUMBLOB, DataType.LONGBLOB, DataType.DECIMAL, DataType.ENUM, DataType.VARSTRING, DataType.STRING, DataType.VARCHAR});

    public static long parseBit(ReadableByteBuf buf, int length) {
        if (length == 1) {
            return buf.readUnsignedByte();
        }
        long val = 0L;
        int idx = 0;
        do {
            val += (long)buf.readUnsignedByte() << 8 * length;
        } while (++idx < length);
        return val;
    }

    @Override
    public String className() {
        return Byte.class.getName();
    }

    @Override
    public boolean canDecode(ColumnDecoder column, Class<?> type) {
        return COMPATIBLE_TYPES.contains((Object)column.getType()) && (type.isPrimitive() && type == Byte.TYPE || type.isAssignableFrom(Byte.class));
    }

    @Override
    public boolean canEncode(Object value) {
        return value instanceof Byte;
    }

    @Override
    public Byte decodeText(ReadableByteBuf buffer, int length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeByteText(buffer, length);
    }

    @Override
    public Byte decodeBinary(ReadableByteBuf buffer, int length, ColumnDecoder column, Calendar cal) throws SQLDataException {
        return column.decodeByteBinary(buffer, length);
    }

    @Override
    public void encodeText(Writer encoder, Context context, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeAscii(Integer.toString(((Byte)value).byteValue()));
    }

    @Override
    public void encodeBinary(Writer encoder, Object value, Calendar cal, Long maxLength) throws IOException {
        encoder.writeByte(((Byte)value).byteValue());
    }

    @Override
    public int getBinaryEncodeType() {
        return DataType.TINYINT.get();
    }
}

