/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.shaded.freemarker.core;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.mapstruct.ap.shaded.freemarker.core.BreakInstruction;
import org.mapstruct.ap.shaded.freemarker.core.Case;
import org.mapstruct.ap.shaded.freemarker.core.Environment;
import org.mapstruct.ap.shaded.freemarker.core.EvalUtil;
import org.mapstruct.ap.shaded.freemarker.core.Expression;
import org.mapstruct.ap.shaded.freemarker.core.ParameterRole;
import org.mapstruct.ap.shaded.freemarker.core.TemplateElement;
import org.mapstruct.ap.shaded.freemarker.template.TemplateException;

final class SwitchBlock
extends TemplateElement {
    private Case defaultCase;
    private final Expression searched;

    SwitchBlock(Expression searched) {
        this.searched = searched;
        this.nestedElements = new LinkedList();
    }

    void addCase(Case cas) {
        if (cas.condition == null) {
            this.defaultCase = cas;
        }
        this.nestedElements.add(cas);
    }

    void accept(Environment env) throws TemplateException, IOException {
        boolean processedCase = false;
        Iterator iterator = this.nestedElements.iterator();
        try {
            while (iterator.hasNext()) {
                Case cas = (Case)iterator.next();
                boolean processCase = false;
                if (processedCase) {
                    processCase = true;
                } else if (cas.condition != null) {
                    processCase = EvalUtil.compare(this.searched, 1, "case==", cas.condition, cas.condition, env);
                }
                if (!processCase) continue;
                env.visitByHiddingParent(cas);
                processedCase = true;
            }
            if (!processedCase && this.defaultCase != null) {
                env.visitByHiddingParent(this.defaultCase);
            }
        }
        catch (BreakInstruction.Break br) {
            // empty catch block
        }
    }

    protected String dump(boolean canonical) {
        StringBuffer buf = new StringBuffer();
        if (canonical) {
            buf.append('<');
        }
        buf.append(this.getNodeTypeSymbol());
        buf.append(' ');
        buf.append(this.searched.getCanonicalForm());
        if (canonical) {
            buf.append('>');
            for (int i = 0; i < this.nestedElements.size(); ++i) {
                Case cas = (Case)this.nestedElements.get(i);
                buf.append(cas.getCanonicalForm());
            }
            buf.append("</").append(this.getNodeTypeSymbol()).append('>');
        }
        return buf.toString();
    }

    String getNodeTypeSymbol() {
        return "#switch";
    }

    int getParameterCount() {
        return 1;
    }

    Object getParameterValue(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.searched;
    }

    ParameterRole getParameterRole(int idx) {
        if (idx != 0) {
            throw new IndexOutOfBoundsException();
        }
        return ParameterRole.VALUE;
    }
}

