/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import javax.annotation.processing.Messager;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.mapstruct.ap.internal.util.AccessorNamingUtils;
import org.mapstruct.ap.internal.util.Services;
import org.mapstruct.ap.spi.AccessorNamingStrategy;
import org.mapstruct.ap.spi.AstModifyingAnnotationProcessor;
import org.mapstruct.ap.spi.BuilderProvider;
import org.mapstruct.ap.spi.DefaultAccessorNamingStrategy;
import org.mapstruct.ap.spi.DefaultBuilderProvider;
import org.mapstruct.ap.spi.DefaultEnumMappingStrategy;
import org.mapstruct.ap.spi.EnumMappingStrategy;
import org.mapstruct.ap.spi.EnumTransformationStrategy;
import org.mapstruct.ap.spi.FreeBuilderAccessorNamingStrategy;
import org.mapstruct.ap.spi.ImmutablesAccessorNamingStrategy;
import org.mapstruct.ap.spi.ImmutablesBuilderProvider;
import org.mapstruct.ap.spi.MapStructProcessingEnvironment;
import org.mapstruct.ap.spi.NoOpBuilderProvider;

public class AnnotationProcessorContext
implements MapStructProcessingEnvironment {
    private List<AstModifyingAnnotationProcessor> astModifyingAnnotationProcessors;
    private BuilderProvider builderProvider;
    private AccessorNamingStrategy accessorNamingStrategy;
    private EnumMappingStrategy enumMappingStrategy;
    private boolean initialized;
    private Map<String, EnumTransformationStrategy> enumTransformationStrategies;
    private AccessorNamingUtils accessorNaming;
    private Elements elementUtils;
    private Types typeUtils;
    private Messager messager;
    private boolean disableBuilder;
    private boolean verbose;

    public AnnotationProcessorContext(Elements elementUtils, Types typeUtils, Messager messager, boolean disableBuilder, boolean verbose) {
        this.astModifyingAnnotationProcessors = Collections.unmodifiableList(AnnotationProcessorContext.findAstModifyingAnnotationProcessors(messager));
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.messager = messager;
        this.disableBuilder = disableBuilder;
        this.verbose = verbose;
    }

    private void initialize() {
        DefaultBuilderProvider defaultBuilderProvider;
        DefaultAccessorNamingStrategy defaultAccessorNamingStrategy;
        if (this.initialized) {
            return;
        }
        if (this.elementUtils.getTypeElement("org.immutables.value.Value.Immutable") != null) {
            defaultAccessorNamingStrategy = new ImmutablesAccessorNamingStrategy();
            defaultBuilderProvider = new ImmutablesBuilderProvider();
            if (this.verbose) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "MapStruct: Immutables found on classpath");
            }
        } else if (this.elementUtils.getTypeElement("org.inferred.freebuilder.FreeBuilder") != null) {
            defaultAccessorNamingStrategy = new FreeBuilderAccessorNamingStrategy();
            defaultBuilderProvider = new DefaultBuilderProvider();
            if (this.verbose) {
                this.messager.printMessage(Diagnostic.Kind.NOTE, "MapStruct: Freebuilder found on classpath");
            }
        } else {
            defaultAccessorNamingStrategy = new DefaultAccessorNamingStrategy();
            defaultBuilderProvider = new DefaultBuilderProvider();
        }
        this.accessorNamingStrategy = Services.get(AccessorNamingStrategy.class, defaultAccessorNamingStrategy);
        this.accessorNamingStrategy.init(this);
        if (this.verbose) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "MapStruct: Using accessor naming strategy: " + this.accessorNamingStrategy.getClass().getCanonicalName());
        }
        this.builderProvider = this.disableBuilder ? new NoOpBuilderProvider() : (BuilderProvider)Services.get(BuilderProvider.class, defaultBuilderProvider);
        this.builderProvider.init(this);
        if (this.verbose) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "MapStruct: Using builder provider: " + this.builderProvider.getClass().getCanonicalName());
        }
        this.accessorNaming = new AccessorNamingUtils(this.accessorNamingStrategy);
        this.enumMappingStrategy = Services.get(EnumMappingStrategy.class, new DefaultEnumMappingStrategy());
        this.enumMappingStrategy.init(this);
        if (this.verbose) {
            this.messager.printMessage(Diagnostic.Kind.NOTE, "MapStruct: Using enum naming strategy: " + this.enumMappingStrategy.getClass().getCanonicalName());
        }
        this.enumTransformationStrategies = new LinkedHashMap<String, EnumTransformationStrategy>();
        ServiceLoader<EnumTransformationStrategy> transformationStrategiesLoader = ServiceLoader.load(EnumTransformationStrategy.class, AnnotationProcessorContext.class.getClassLoader());
        for (EnumTransformationStrategy transformationStrategy : transformationStrategiesLoader) {
            String transformationStrategyName = transformationStrategy.getStrategyName();
            if (this.enumTransformationStrategies.containsKey(transformationStrategyName)) {
                throw new IllegalStateException("Multiple EnumTransformationStrategies are using the same ma,e. Found: " + this.enumTransformationStrategies.get(transformationStrategyName) + " and " + transformationStrategy + " for name " + transformationStrategyName);
            }
            transformationStrategy.init(this);
            this.enumTransformationStrategies.put(transformationStrategyName, transformationStrategy);
        }
        this.initialized = true;
    }

    private static List<AstModifyingAnnotationProcessor> findAstModifyingAnnotationProcessors(Messager messager) {
        ArrayList<AstModifyingAnnotationProcessor> processors = new ArrayList<AstModifyingAnnotationProcessor>();
        ServiceLoader<AstModifyingAnnotationProcessor> loader = ServiceLoader.load(AstModifyingAnnotationProcessor.class, AnnotationProcessorContext.class.getClassLoader());
        FaultyDelegatingIterator loaderIterator = new FaultyDelegatingIterator(messager, loader.iterator());
        while (loaderIterator.hasNext()) {
            AstModifyingAnnotationProcessor processor = (AstModifyingAnnotationProcessor)loaderIterator.next();
            if (processor == null) continue;
            processors.add(processor);
        }
        return processors;
    }

    @Override
    public Elements getElementUtils() {
        return this.elementUtils;
    }

    @Override
    public Types getTypeUtils() {
        return this.typeUtils;
    }

    public List<AstModifyingAnnotationProcessor> getAstModifyingAnnotationProcessors() {
        return this.astModifyingAnnotationProcessors;
    }

    public AccessorNamingUtils getAccessorNaming() {
        this.initialize();
        return this.accessorNaming;
    }

    public AccessorNamingStrategy getAccessorNamingStrategy() {
        this.initialize();
        return this.accessorNamingStrategy;
    }

    public EnumMappingStrategy getEnumMappingStrategy() {
        this.initialize();
        return this.enumMappingStrategy;
    }

    public BuilderProvider getBuilderProvider() {
        this.initialize();
        return this.builderProvider;
    }

    public Map<String, EnumTransformationStrategy> getEnumTransformationStrategies() {
        this.initialize();
        return this.enumTransformationStrategies;
    }

    private static class FaultyDelegatingIterator
    implements Iterator<AstModifyingAnnotationProcessor> {
        private final Messager messager;
        private final Iterator<AstModifyingAnnotationProcessor> delegate;

        private FaultyDelegatingIterator(Messager messager, Iterator<AstModifyingAnnotationProcessor> delegate) {
            this.messager = messager;
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            for (int failures = 5; failures > 0; --failures) {
                try {
                    return this.delegate.hasNext();
                }
                catch (Throwable t) {
                    this.logFailure(t);
                    continue;
                }
            }
            return false;
        }

        @Override
        public AstModifyingAnnotationProcessor next() {
            try {
                return this.delegate.next();
            }
            catch (Throwable t) {
                this.logFailure(t);
                return null;
            }
        }

        private void logFailure(Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            String reportableStacktrace = sw.toString().replace(System.lineSeparator(), "  ");
            this.messager.printMessage(Diagnostic.Kind.WARNING, "Failed to read AstModifyingAnnotationProcessor. Reading next processor. Reason: " + reportableStacktrace);
        }
    }
}

