/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.mapstruct.ap.internal.model.MapperReference;
import org.mapstruct.ap.internal.model.common.Assignment;
import org.mapstruct.ap.internal.model.common.ConversionContext;
import org.mapstruct.ap.internal.model.common.ModelElement;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.ParameterBinding;
import org.mapstruct.ap.internal.model.common.PresenceCheck;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.source.Method;
import org.mapstruct.ap.internal.model.source.builtin.BuiltInMethod;
import org.mapstruct.ap.internal.util.Strings;

public class MethodReference
extends ModelElement
implements Assignment {
    private final String name;
    private final List<Parameter> sourceParameters;
    private final Type returnType;
    private final MapperReference declaringMapper;
    private final Set<Type> importTypes;
    private final List<Type> thrownTypes;
    private final boolean isUpdateMethod;
    private final String contextParam;
    private Assignment assignment;
    private final Type definingType;
    private final List<ParameterBinding> parameterBindings;
    private final Parameter providingParameter;
    private final List<MethodReference> methodsToChain;
    private final boolean isStatic;
    private final boolean isConstructor;
    private final boolean isMethodChaining;

    protected MethodReference(Method method, MapperReference declaringMapper, Parameter providingParameter, List<ParameterBinding> parameterBindings) {
        this.declaringMapper = declaringMapper;
        this.sourceParameters = Parameter.getSourceParameters(method.getParameters());
        this.returnType = method.getReturnType();
        this.providingParameter = providingParameter;
        this.parameterBindings = parameterBindings;
        this.contextParam = null;
        HashSet<Type> imported = new HashSet<Type>();
        for (Type type : method.getThrownTypes()) {
            imported.addAll(type.getImportTypes());
        }
        for (ParameterBinding binding : parameterBindings) {
            imported.addAll(binding.getImportTypes());
        }
        this.importTypes = Collections.unmodifiableSet(imported);
        this.thrownTypes = method.getThrownTypes();
        this.isUpdateMethod = method.getMappingTargetParameter() != null;
        this.definingType = method.getDefiningType();
        this.isStatic = method.isStatic();
        this.name = method.getName();
        this.isConstructor = false;
        this.methodsToChain = Collections.emptyList();
        this.isMethodChaining = false;
    }

    private MethodReference(BuiltInMethod method, ConversionContext contextParam) {
        this.sourceParameters = Parameter.getSourceParameters(method.getParameters());
        this.returnType = method.getReturnType();
        this.declaringMapper = null;
        this.providingParameter = null;
        this.contextParam = method.getContextParameter(contextParam);
        this.importTypes = Collections.emptySet();
        this.thrownTypes = Collections.emptyList();
        this.definingType = null;
        this.isUpdateMethod = method.getMappingTargetParameter() != null;
        this.parameterBindings = ParameterBinding.fromParameters(method.getParameters());
        this.isStatic = method.isStatic();
        this.name = method.getName();
        this.isConstructor = false;
        this.methodsToChain = Collections.emptyList();
        this.isMethodChaining = false;
    }

    private MethodReference(String name, Type definingType, boolean isStatic) {
        this.name = name;
        this.definingType = definingType;
        this.sourceParameters = Collections.emptyList();
        this.returnType = null;
        this.declaringMapper = null;
        this.importTypes = Collections.emptySet();
        this.thrownTypes = Collections.emptyList();
        this.isUpdateMethod = false;
        this.contextParam = null;
        this.parameterBindings = Collections.emptyList();
        this.providingParameter = null;
        this.isStatic = isStatic;
        this.isConstructor = false;
        this.methodsToChain = Collections.emptyList();
        this.isMethodChaining = false;
    }

    private MethodReference(Type definingType, List<ParameterBinding> parameterBindings) {
        this.name = null;
        this.definingType = definingType;
        this.sourceParameters = Collections.emptyList();
        this.returnType = null;
        this.declaringMapper = null;
        this.thrownTypes = Collections.emptyList();
        this.isUpdateMethod = false;
        this.contextParam = null;
        this.parameterBindings = parameterBindings;
        this.providingParameter = null;
        this.isStatic = false;
        this.isConstructor = true;
        this.methodsToChain = Collections.emptyList();
        this.isMethodChaining = false;
        if (parameterBindings.isEmpty()) {
            this.importTypes = Collections.emptySet();
        } else {
            LinkedHashSet<Type> imported = new LinkedHashSet<Type>();
            for (ParameterBinding binding : parameterBindings) {
                imported.add(binding.getType());
            }
            imported.add(definingType);
            this.importTypes = Collections.unmodifiableSet(imported);
        }
    }

    private MethodReference(MethodReference ... references) {
        this.name = null;
        this.definingType = null;
        this.sourceParameters = Collections.emptyList();
        this.returnType = null;
        this.declaringMapper = null;
        this.importTypes = Collections.emptySet();
        this.thrownTypes = Collections.emptyList();
        this.isUpdateMethod = false;
        this.contextParam = null;
        this.parameterBindings = null;
        this.providingParameter = null;
        this.isStatic = false;
        this.isConstructor = false;
        this.methodsToChain = Arrays.asList(references);
        this.isMethodChaining = true;
    }

    public MapperReference getDeclaringMapper() {
        return this.declaringMapper;
    }

    public Parameter getProvidingParameter() {
        return this.providingParameter;
    }

    public String getMapperVariableName() {
        return this.declaringMapper.getVariableName();
    }

    public String getContextParam() {
        return this.contextParam;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getSourceParameters() {
        return this.sourceParameters;
    }

    @Override
    public void setAssignment(Assignment assignment) {
        this.assignment = assignment;
    }

    @Override
    public String getSourceReference() {
        return this.assignment != null ? this.assignment.getSourceReference() : null;
    }

    @Override
    public PresenceCheck getSourcePresenceCheckerReference() {
        return this.assignment.getSourcePresenceCheckerReference();
    }

    @Override
    public Type getSourceType() {
        return this.assignment.getSourceType();
    }

    @Override
    public String createUniqueVarName(String desiredName) {
        return this.assignment.createUniqueVarName(desiredName);
    }

    @Override
    public String getSourceLocalVarName() {
        return this.assignment.getSourceLocalVarName();
    }

    @Override
    public void setSourceLocalVarName(String sourceLocalVarName) {
        this.assignment.setSourceLocalVarName(sourceLocalVarName);
    }

    @Override
    public String getSourceLoopVarName() {
        return this.assignment.getSourceLoopVarName();
    }

    @Override
    public void setSourceLoopVarName(String sourceLoopVarName) {
        this.assignment.setSourceLoopVarName(sourceLoopVarName);
    }

    @Override
    public String getSourceParameterName() {
        return this.assignment.getSourceParameterName();
    }

    @Override
    public boolean isSourceReferenceParameter() {
        return this.assignment.isSourceReferenceParameter();
    }

    public Type getSingleSourceParameterType() {
        for (Parameter parameter : this.getSourceParameters()) {
            if (parameter.isTargetType()) continue;
            return parameter.getType();
        }
        return null;
    }

    public Type getDefiningType() {
        return this.definingType;
    }

    @Override
    public Set<Type> getImportTypes() {
        HashSet<Type> imported = new HashSet<Type>(this.importTypes);
        if (this.assignment != null) {
            imported.addAll(this.assignment.getImportTypes());
        }
        if (this.isStatic()) {
            imported.add(this.definingType);
        }
        if (this.isMethodChaining()) {
            for (MethodReference methodToChain : this.methodsToChain) {
                imported.addAll(methodToChain.getImportTypes());
            }
        }
        return imported;
    }

    @Override
    public List<Type> getThrownTypes() {
        ArrayList<Type> exceptions = new ArrayList<Type>(this.thrownTypes);
        if (this.assignment != null) {
            exceptions.addAll(this.assignment.getThrownTypes());
        }
        if (this.isMethodChaining()) {
            for (MethodReference methodToChain : this.methodsToChain) {
                exceptions.addAll(methodToChain.getThrownTypes());
            }
        }
        return exceptions;
    }

    @Override
    public Assignment.AssignmentType getType() {
        switch (this.assignment.getType()) {
            case DIRECT: {
                return Assignment.AssignmentType.MAPPED;
            }
            case MAPPED: {
                return Assignment.AssignmentType.MAPPED_TWICE;
            }
            case TYPE_CONVERTED: {
                return Assignment.AssignmentType.TYPE_CONVERTED_MAPPED;
            }
        }
        return null;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean isCallingUpdateMethod() {
        return this.isUpdateMethod;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public boolean isConstructor() {
        return this.isConstructor;
    }

    public boolean isMethodChaining() {
        return this.isMethodChaining;
    }

    public List<MethodReference> getMethodsToChain() {
        return this.methodsToChain;
    }

    public List<ParameterBinding> getParameterBindings() {
        return this.parameterBindings;
    }

    public Type inferTypeWhenEnum(Type type) {
        if ("java.lang.Enum".equals(type.getFullyQualifiedName())) {
            return type.getTypeParameters().get(0);
        }
        return type;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.declaringMapper == null ? 0 : this.declaringMapper.hashCode());
        result = 31 * result + (this.providingParameter == null ? 0 : this.providingParameter.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodReference other = (MethodReference)obj;
        if (!Objects.equals(this.declaringMapper, other.declaringMapper)) {
            return false;
        }
        return Objects.equals(this.providingParameter, other.providingParameter);
    }

    public static MethodReference forBuiltInMethod(BuiltInMethod method, ConversionContext contextParam) {
        return new MethodReference(method, contextParam);
    }

    public static MethodReference forForgedMethod(Method method, List<ParameterBinding> parameterBindings) {
        return new MethodReference(method, null, null, parameterBindings);
    }

    public static MethodReference forParameterProvidedMethod(Method method, Parameter providingParameter, List<ParameterBinding> parameterBindings) {
        return new MethodReference(method, null, providingParameter, parameterBindings);
    }

    public static MethodReference forMapperReference(Method method, MapperReference declaringMapper, List<ParameterBinding> parameterBindings) {
        return new MethodReference(method, declaringMapper, null, parameterBindings);
    }

    public static MethodReference forStaticBuilder(String builderCreationMethod, Type definingType) {
        return new MethodReference(builderCreationMethod, definingType, true);
    }

    public static MethodReference forMethodCall(String methodName) {
        return new MethodReference(methodName, null, false);
    }

    public static MethodReference forConstructorInvocation(Type type, List<ParameterBinding> parameterBindings) {
        return new MethodReference(type, parameterBindings);
    }

    public static MethodReference forMethodChaining(MethodReference ... references) {
        return new MethodReference(references);
    }

    public String toString() {
        String mapper;
        String string = mapper = this.declaringMapper != null ? this.declaringMapper.getType().getName() : "";
        String argument = this.getAssignment() != null ? this.getAssignment().toString() : (this.getSourceReference() != null ? this.getSourceReference() : "");
        String returnTypeAsString = this.returnType != null ? this.returnType.toString() : "";
        List arguments = this.sourceParameters.stream().map(p -> p.isMappingContext() || p.isMappingTarget() || p.isTargetType() ? p.getName() : argument).collect(Collectors.toList());
        return returnTypeAsString + " " + mapper + "#" + this.name + "(" + Strings.join(arguments, ",") + ")";
    }
}

