/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import org.mapstruct.ap.internal.gem.BeanMappingGem;
import org.mapstruct.ap.internal.gem.ConditionGem;
import org.mapstruct.ap.internal.gem.IterableMappingGem;
import org.mapstruct.ap.internal.gem.MapMappingGem;
import org.mapstruct.ap.internal.gem.MappingGem;
import org.mapstruct.ap.internal.gem.MappingsGem;
import org.mapstruct.ap.internal.gem.ObjectFactoryGem;
import org.mapstruct.ap.internal.gem.ValueMappingGem;
import org.mapstruct.ap.internal.gem.ValueMappingsGem;
import org.mapstruct.ap.internal.model.common.Parameter;
import org.mapstruct.ap.internal.model.common.Type;
import org.mapstruct.ap.internal.model.common.TypeFactory;
import org.mapstruct.ap.internal.model.source.BeanMappingOptions;
import org.mapstruct.ap.internal.model.source.EnumMappingOptions;
import org.mapstruct.ap.internal.model.source.IterableMappingOptions;
import org.mapstruct.ap.internal.model.source.MapMappingOptions;
import org.mapstruct.ap.internal.model.source.MapperOptions;
import org.mapstruct.ap.internal.model.source.MappingOptions;
import org.mapstruct.ap.internal.model.source.ParameterProvidedMethods;
import org.mapstruct.ap.internal.model.source.SourceMethod;
import org.mapstruct.ap.internal.model.source.ValueMappingOptions;
import org.mapstruct.ap.internal.option.Options;
import org.mapstruct.ap.internal.processor.ModelElementProcessor;
import org.mapstruct.ap.internal.util.AccessorNamingUtils;
import org.mapstruct.ap.internal.util.AnnotationProcessingException;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.internal.util.Executables;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.TypeUtils;
import org.mapstruct.ap.spi.EnumTransformationStrategy;

public class MethodRetrievalProcessor
implements ModelElementProcessor<Void, List<SourceMethod>> {
    private static final String JAVA_LANG_ANNOTATION_PGK = "java.lang.annotation";
    private static final String ORG_MAPSTRUCT_PKG = "org.mapstruct";
    private static final String MAPPING_FQN = "org.mapstruct.Mapping";
    private static final String MAPPINGS_FQN = "org.mapstruct.Mappings";
    private FormattingMessager messager;
    private TypeFactory typeFactory;
    private AccessorNamingUtils accessorNaming;
    private Map<String, EnumTransformationStrategy> enumTransformationStrategies;
    private TypeUtils typeUtils;
    private ElementUtils elementUtils;
    private Options options;

    @Override
    public List<SourceMethod> process(ModelElementProcessor.ProcessorContext context, TypeElement mapperTypeElement, Void sourceModel) {
        this.messager = context.getMessager();
        this.typeFactory = context.getTypeFactory();
        this.accessorNaming = context.getAccessorNaming();
        this.typeUtils = context.getTypeUtils();
        this.elementUtils = context.getElementUtils();
        this.enumTransformationStrategies = context.getEnumTransformationStrategies();
        this.options = context.getOptions();
        this.messager.note(0, Message.PROCESSING_NOTE, mapperTypeElement);
        MapperOptions mapperOptions = MapperOptions.getInstanceOn(mapperTypeElement, context.getOptions());
        if (mapperOptions.hasMapperConfig()) {
            this.messager.note(0, Message.CONFIG_NOTE, mapperOptions.mapperConfigType().asElement().getSimpleName());
        }
        if (!mapperOptions.isValid()) {
            throw new AnnotationProcessingException("Couldn't retrieve @Mapper annotation", mapperTypeElement, mapperOptions.getAnnotationMirror());
        }
        List<SourceMethod> prototypeMethods = this.retrievePrototypeMethods(mapperTypeElement, mapperOptions);
        return this.retrieveMethods(mapperTypeElement, mapperTypeElement, mapperOptions, prototypeMethods);
    }

    @Override
    public int getPriority() {
        return 1;
    }

    private List<SourceMethod> retrievePrototypeMethods(TypeElement mapperTypeElement, MapperOptions mapperAnnotation) {
        if (!mapperAnnotation.hasMapperConfig()) {
            return Collections.emptyList();
        }
        TypeElement typeElement = this.asTypeElement(mapperAnnotation.mapperConfigType());
        ArrayList<SourceMethod> methods = new ArrayList<SourceMethod>();
        for (ExecutableElement executable : this.elementUtils.getAllEnclosedExecutableElements(typeElement)) {
            List<SourceMethod> prototypeMethods;
            boolean containsTargetTypeParameter;
            List<Parameter> parameters;
            ExecutableType methodType = this.typeFactory.getMethodType(mapperAnnotation.mapperConfigType(), executable);
            SourceMethod method = this.getMethodRequiringImplementation(methodType, executable, parameters = this.typeFactory.getParameters(methodType, executable), containsTargetTypeParameter = SourceMethod.containsTargetTypeParameter(parameters), mapperAnnotation, prototypeMethods = Collections.emptyList(), mapperTypeElement);
            if (method == null) continue;
            methods.add(method);
        }
        return methods;
    }

    private List<SourceMethod> retrieveMethods(TypeElement usedMapper, TypeElement mapperToImplement, MapperOptions mapperOptions, List<SourceMethod> prototypeMethods) {
        ArrayList<SourceMethod> methods = new ArrayList<SourceMethod>();
        for (ExecutableElement executable : this.elementUtils.getAllEnclosedExecutableElements(usedMapper)) {
            SourceMethod method = this.getMethod(usedMapper, executable, mapperToImplement, mapperOptions, prototypeMethods);
            if (method == null) continue;
            methods.add(method);
        }
        if (usedMapper.equals(mapperToImplement)) {
            for (DeclaredType mapper : mapperOptions.uses()) {
                TypeElement usesMapperElement = this.asTypeElement(mapper);
                if (!mapperToImplement.equals(usesMapperElement)) {
                    methods.addAll(this.retrieveMethods(usesMapperElement, mapperToImplement, mapperOptions, prototypeMethods));
                    continue;
                }
                this.messager.printMessage((Element)mapperToImplement, mapperOptions.getAnnotationMirror(), Message.RETRIEVAL_MAPPER_USES_CYCLE, mapperToImplement);
            }
        }
        return methods;
    }

    private TypeElement asTypeElement(DeclaredType type) {
        return (TypeElement)type.asElement();
    }

    private SourceMethod getMethod(TypeElement usedMapper, ExecutableElement method, TypeElement mapperToImplement, MapperOptions mapperOptions, List<SourceMethod> prototypeMethods) {
        ExecutableType methodType = this.typeFactory.getMethodType((DeclaredType)usedMapper.asType(), method);
        List<Parameter> parameters = this.typeFactory.getParameters(methodType, method);
        Type returnType = this.typeFactory.getReturnType(methodType);
        boolean methodRequiresImplementation = method.getModifiers().contains((Object)Modifier.ABSTRACT);
        boolean containsTargetTypeParameter = SourceMethod.containsTargetTypeParameter(parameters);
        if (usedMapper.equals(mapperToImplement) && methodRequiresImplementation) {
            return this.getMethodRequiringImplementation(methodType, method, parameters, containsTargetTypeParameter, mapperOptions, prototypeMethods, mapperToImplement);
        }
        if (this.isValidReferencedMethod(parameters) || this.isValidFactoryMethod(method, parameters, returnType) || this.isValidLifecycleCallbackMethod(method) || this.isValidPresenceCheckMethod(method, returnType)) {
            return this.getReferencedMethod(usedMapper, methodType, method, mapperToImplement, parameters);
        }
        return null;
    }

    private SourceMethod getMethodRequiringImplementation(ExecutableType methodType, ExecutableElement method, List<Parameter> parameters, boolean containsTargetTypeParameter, MapperOptions mapperOptions, List<SourceMethod> prototypeMethods, TypeElement mapperToImplement) {
        Type resultType;
        Type returnType = this.typeFactory.getReturnType(methodType);
        List<Type> exceptionTypes = this.typeFactory.getThrownTypes(methodType);
        List<Parameter> sourceParameters = Parameter.getSourceParameters(parameters);
        List<Parameter> contextParameters = Parameter.getContextParameters(parameters);
        Parameter targetParameter = this.extractTargetParameter(parameters);
        boolean isValid = this.checkParameterAndReturnType(method, sourceParameters, targetParameter, contextParameters, resultType = this.selectResultType(returnType, targetParameter), returnType, containsTargetTypeParameter);
        if (!isValid) {
            return null;
        }
        ParameterProvidedMethods contextProvidedMethods = this.retrieveContextProvidedMethods(contextParameters, mapperToImplement, mapperOptions);
        BeanMappingOptions beanMappingOptions = BeanMappingOptions.getInstanceOn(BeanMappingGem.instanceOn(method), mapperOptions, method, this.messager, this.typeUtils, this.typeFactory);
        Set<MappingOptions> mappingOptions = this.getMappings(method, method, beanMappingOptions, new LinkedHashSet<MappingOptions>(), new HashSet<Element>());
        IterableMappingOptions iterableMappingOptions = IterableMappingOptions.fromGem(IterableMappingGem.instanceOn(method), mapperOptions, method, this.messager, this.typeUtils);
        MapMappingOptions mapMappingOptions = MapMappingOptions.fromGem(MapMappingGem.instanceOn(method), mapperOptions, method, this.messager, this.typeUtils);
        EnumMappingOptions enumMappingOptions = EnumMappingOptions.getInstanceOn(method, mapperOptions, this.enumTransformationStrategies, this.messager);
        return new SourceMethod.Builder().setExecutable(method).setParameters(parameters).setReturnType(returnType).setExceptionTypes(exceptionTypes).setMapper(mapperOptions).setBeanMappingOptions(beanMappingOptions).setMappingOptions(mappingOptions).setIterableMappingOptions(iterableMappingOptions).setMapMappingOptions(mapMappingOptions).setValueMappingOptionss(this.getValueMappings(method)).setEnumMappingOptions(enumMappingOptions).setTypeUtils(this.typeUtils).setTypeFactory(this.typeFactory).setPrototypeMethods(prototypeMethods).setContextProvidedMethods(contextProvidedMethods).setVerboseLogging(this.options.isVerbose()).build();
    }

    private ParameterProvidedMethods retrieveContextProvidedMethods(List<Parameter> contextParameters, TypeElement mapperToImplement, MapperOptions mapperConfig) {
        ParameterProvidedMethods.Builder builder = ParameterProvidedMethods.builder();
        for (Parameter contextParam : contextParameters) {
            if (contextParam.getType().isPrimitive() || contextParam.getType().isArrayType()) continue;
            List<SourceMethod> contextParamMethods = this.retrieveMethods(contextParam.getType().getTypeElement(), mapperToImplement, mapperConfig, Collections.emptyList());
            ArrayList<SourceMethod> contextProvidedMethods = new ArrayList<SourceMethod>(contextParamMethods.size());
            for (SourceMethod sourceMethod : contextParamMethods) {
                if (!sourceMethod.isLifecycleCallbackMethod() && !sourceMethod.isObjectFactory() && !sourceMethod.isPresenceCheck()) continue;
                contextProvidedMethods.add(sourceMethod);
            }
            builder.addMethodsForParameter(contextParam, contextProvidedMethods);
        }
        return builder.build();
    }

    private SourceMethod getReferencedMethod(TypeElement usedMapper, ExecutableType methodType, ExecutableElement method, TypeElement mapperToImplement, List<Parameter> parameters) {
        Type returnType = this.typeFactory.getReturnType(methodType);
        List<Type> exceptionTypes = this.typeFactory.getThrownTypes(methodType);
        Type usedMapperAsType = this.typeFactory.getType(usedMapper);
        Type mapperToImplementAsType = this.typeFactory.getType(mapperToImplement);
        if (!mapperToImplementAsType.canAccess(usedMapperAsType, method)) {
            return null;
        }
        Type definingType = this.typeFactory.getType(method.getEnclosingElement().asType());
        return new SourceMethod.Builder().setDeclaringMapper(usedMapper.equals(mapperToImplement) ? null : usedMapperAsType).setDefininingType(definingType).setExecutable(method).setParameters(parameters).setReturnType(returnType).setExceptionTypes(exceptionTypes).setTypeUtils(this.typeUtils).setTypeFactory(this.typeFactory).setVerboseLogging(this.options.isVerbose()).build();
    }

    private boolean isValidLifecycleCallbackMethod(ExecutableElement method) {
        return Executables.isLifecycleCallbackMethod(method);
    }

    private boolean isValidReferencedMethod(List<Parameter> parameters) {
        return this.isValidReferencedOrFactoryMethod(1, 1, parameters);
    }

    private boolean isValidFactoryMethod(ExecutableElement method, List<Parameter> parameters, Type returnType) {
        return !this.isVoid(returnType) && (this.isValidReferencedOrFactoryMethod(0, 0, parameters) || this.hasFactoryAnnotation(method));
    }

    private boolean hasFactoryAnnotation(ExecutableElement method) {
        return ObjectFactoryGem.instanceOn(method) != null;
    }

    private boolean isValidPresenceCheckMethod(ExecutableElement method, Type returnType) {
        return this.isBoolean(returnType) && this.hasConditionAnnotation(method);
    }

    private boolean hasConditionAnnotation(ExecutableElement method) {
        return ConditionGem.instanceOn(method) != null;
    }

    private boolean isVoid(Type returnType) {
        return returnType.getTypeMirror().getKind() == TypeKind.VOID;
    }

    private boolean isBoolean(Type returnType) {
        return Boolean.class.getCanonicalName().equals(returnType.getBoxedEquivalent().getFullyQualifiedName());
    }

    private boolean isValidReferencedOrFactoryMethod(int sourceParamCount, int targetParamCount, List<Parameter> parameters) {
        int validSourceParameters = 0;
        int targetParameters = 0;
        int targetTypeParameters = 0;
        for (Parameter param : parameters) {
            if (param.isMappingTarget()) {
                ++targetParameters;
                continue;
            }
            if (param.isTargetType()) {
                ++targetTypeParameters;
                continue;
            }
            if (param.isMappingContext()) continue;
            ++validSourceParameters;
        }
        return validSourceParameters == sourceParamCount && targetParameters <= targetParamCount && targetTypeParameters <= 1;
    }

    private Parameter extractTargetParameter(List<Parameter> parameters) {
        for (Parameter param : parameters) {
            if (!param.isMappingTarget()) continue;
            return param;
        }
        return null;
    }

    private Type selectResultType(Type returnType, Parameter targetParameter) {
        if (null != targetParameter) {
            return targetParameter.getType();
        }
        return returnType;
    }

    private boolean checkParameterAndReturnType(ExecutableElement method, List<Parameter> sourceParameters, Parameter targetParameter, List<Parameter> contextParameters, Type resultType, Type returnType, boolean containsTargetTypeParameter) {
        if (sourceParameters.isEmpty()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_NO_INPUT_ARGS, new Object[0]);
            return false;
        }
        if (targetParameter != null && sourceParameters.size() + contextParameters.size() + 1 != method.getParameters().size()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_DUPLICATE_MAPPING_TARGETS, new Object[0]);
            return false;
        }
        if (this.isVoid(resultType)) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_VOID_MAPPING_METHOD, new Object[0]);
            return false;
        }
        if (returnType.getTypeMirror().getKind() != TypeKind.VOID && !resultType.isAssignableTo(returnType) && !resultType.isAssignableTo(this.typeFactory.effectiveResultTypeFor(returnType, null))) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_NON_ASSIGNABLE_RESULTTYPE, new Object[0]);
            return false;
        }
        for (Parameter parameter : sourceParameters) {
            if (!parameter.getType().isTypeVar()) continue;
            this.messager.printMessage((Element)method, Message.RETRIEVAL_TYPE_VAR_SOURCE, new Object[0]);
            return false;
        }
        HashSet<Type> contextParameterTypes = new HashSet<Type>();
        for (Parameter contextParameter : contextParameters) {
            if (contextParameterTypes.add(contextParameter.getType())) continue;
            this.messager.printMessage((Element)method, Message.RETRIEVAL_CONTEXT_PARAMS_WITH_SAME_TYPE, new Object[0]);
            return false;
        }
        if (returnType.isTypeVar() || resultType.isTypeVar()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_TYPE_VAR_RESULT, new Object[0]);
            return false;
        }
        Type type = sourceParameters.get(0).getType();
        if (this.isStreamTypeOrIterableFromJavaStdLib(type) && !resultType.isIterableOrStreamType()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_ITERABLE_TO_NON_ITERABLE, new Object[0]);
            return false;
        }
        if (containsTargetTypeParameter) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_MAPPING_HAS_TARGET_TYPE_PARAMETER, new Object[0]);
            return false;
        }
        if (!type.isIterableOrStreamType() && this.isStreamTypeOrIterableFromJavaStdLib(resultType)) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_NON_ITERABLE_TO_ITERABLE, new Object[0]);
            return false;
        }
        if (type.isPrimitive()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_PRIMITIVE_PARAMETER, new Object[0]);
            return false;
        }
        if (resultType.isPrimitive()) {
            this.messager.printMessage((Element)method, Message.RETRIEVAL_PRIMITIVE_RETURN, new Object[0]);
            return false;
        }
        for (Type typeParameter : resultType.getTypeParameters()) {
            if (typeParameter.isTypeVar()) {
                this.messager.printMessage((Element)method, Message.RETRIEVAL_TYPE_VAR_RESULT, new Object[0]);
                return false;
            }
            if (!typeParameter.hasExtendsBound()) continue;
            this.messager.printMessage((Element)method, Message.RETRIEVAL_WILDCARD_EXTENDS_BOUND_RESULT, new Object[0]);
            return false;
        }
        for (Type typeParameter : type.getTypeParameters()) {
            if (typeParameter.hasSuperBound()) {
                this.messager.printMessage((Element)method, Message.RETRIEVAL_WILDCARD_SUPER_BOUND_SOURCE, new Object[0]);
                return false;
            }
            if (!typeParameter.isTypeVar()) continue;
            this.messager.printMessage((Element)method, Message.RETRIEVAL_TYPE_VAR_SOURCE, new Object[0]);
            return false;
        }
        return true;
    }

    private boolean isStreamTypeOrIterableFromJavaStdLib(Type type) {
        return type.isStreamType() || type.isIterableType() && type.isJavaLangType();
    }

    private Set<MappingOptions> getMappings(ExecutableElement method, Element element, BeanMappingOptions beanMapping, Set<MappingOptions> mappingOptions, Set<Element> handledElements) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            Element lElement = annotationMirror.getAnnotationType().asElement();
            if (this.isAnnotation(lElement, MAPPING_FQN)) {
                MappingGem mapping = MappingGem.instanceOn(element);
                MappingOptions.addInstance(mapping, method, beanMapping, this.messager, this.typeUtils, mappingOptions);
                continue;
            }
            if (this.isAnnotation(lElement, MAPPINGS_FQN)) {
                MappingsGem mappings = MappingsGem.instanceOn(element);
                MappingOptions.addInstances(mappings, method, beanMapping, this.messager, this.typeUtils, mappingOptions);
                continue;
            }
            if (this.isAnnotationInPackage(lElement, JAVA_LANG_ANNOTATION_PGK) || this.isAnnotationInPackage(lElement, ORG_MAPSTRUCT_PKG) || handledElements.contains(lElement)) continue;
            handledElements.add(lElement);
            this.getMappings(method, lElement, beanMapping, mappingOptions, handledElements);
        }
        return mappingOptions;
    }

    private boolean isAnnotationInPackage(Element element, String packageFQN) {
        if (ElementKind.ANNOTATION_TYPE == element.getKind()) {
            return packageFQN.equals(this.elementUtils.getPackageOf(element).getQualifiedName().toString());
        }
        return false;
    }

    private boolean isAnnotation(Element element, String annotationFQN) {
        if (ElementKind.ANNOTATION_TYPE == element.getKind()) {
            return annotationFQN.equals(((TypeElement)element).getQualifiedName().toString());
        }
        return false;
    }

    private List<ValueMappingOptions> getValueMappings(ExecutableElement method) {
        ValueMappingOptions valueMapping;
        ArrayList<ValueMappingOptions> valueMappings = new ArrayList<ValueMappingOptions>();
        ValueMappingGem mappingAnnotation = ValueMappingGem.instanceOn(method);
        ValueMappingsGem mappingsAnnotation = ValueMappingsGem.instanceOn(method);
        if (mappingAnnotation != null && (valueMapping = ValueMappingOptions.fromMappingGem(mappingAnnotation)) != null) {
            valueMappings.add(valueMapping);
        }
        if (mappingsAnnotation != null) {
            ValueMappingOptions.fromMappingsGem(mappingsAnnotation, method, this.messager, valueMappings);
        }
        return valueMappings;
    }
}

