/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source.selector;

import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.internal.model.common.SourceRHS;
import org.mapstruct.ap.internal.model.source.MappingControl;
import org.mapstruct.ap.internal.model.source.SelectionParameters;

public class SelectionCriteria {
    private final List<TypeMirror> qualifiers = new ArrayList<TypeMirror>();
    private final List<String> qualifiedByNames = new ArrayList<String>();
    private final String targetPropertyName;
    private final TypeMirror qualifyingResultType;
    private final SourceRHS sourceRHS;
    private Type type;
    private final boolean allowDirect;
    private final boolean allowConversion;
    private final boolean allowMappingMethod;
    private final boolean allow2Steps;

    public SelectionCriteria(SelectionParameters selectionParameters, MappingControl mappingControl, String targetPropertyName, Type type) {
        if (selectionParameters != null) {
            if (type == Type.PRESENCE_CHECK) {
                this.qualifiers.addAll(selectionParameters.getConditionQualifiers());
                this.qualifiedByNames.addAll(selectionParameters.getConditionQualifyingNames());
            } else {
                this.qualifiers.addAll(selectionParameters.getQualifiers());
                this.qualifiedByNames.addAll(selectionParameters.getQualifyingNames());
            }
            this.qualifyingResultType = selectionParameters.getResultType();
            this.sourceRHS = selectionParameters.getSourceRHS();
        } else {
            this.qualifyingResultType = null;
            this.sourceRHS = null;
        }
        if (mappingControl != null) {
            this.allowDirect = mappingControl.allowDirect();
            this.allowConversion = mappingControl.allowTypeConversion();
            this.allowMappingMethod = mappingControl.allowMappingMethod();
            this.allow2Steps = mappingControl.allowBy2Steps();
        } else {
            this.allowDirect = true;
            this.allowConversion = true;
            this.allowMappingMethod = true;
            this.allow2Steps = true;
        }
        this.targetPropertyName = targetPropertyName;
        this.type = type;
    }

    public boolean isObjectFactoryRequired() {
        return this.type == Type.OBJECT_FACTORY;
    }

    public boolean isLifecycleCallbackRequired() {
        return this.type == Type.LIFECYCLE_CALLBACK;
    }

    public boolean isPresenceCheckRequired() {
        return this.type == Type.PRESENCE_CHECK;
    }

    public List<TypeMirror> getQualifiers() {
        return this.qualifiers;
    }

    public List<String> getQualifiedByNames() {
        return this.qualifiedByNames;
    }

    public String getTargetPropertyName() {
        return this.targetPropertyName;
    }

    public TypeMirror getQualifyingResultType() {
        return this.qualifyingResultType;
    }

    public boolean isPreferUpdateMapping() {
        return this.type == Type.PREFER_UPDATE_MAPPING;
    }

    public SourceRHS getSourceRHS() {
        return this.sourceRHS;
    }

    public void setPreferUpdateMapping(boolean preferUpdateMapping) {
        this.type = preferUpdateMapping ? Type.PREFER_UPDATE_MAPPING : null;
    }

    public boolean hasQualfiers() {
        return !this.qualifiedByNames.isEmpty() || !this.qualifiers.isEmpty();
    }

    public boolean isAllowDirect() {
        return this.allowDirect;
    }

    public boolean isAllowConversion() {
        return this.allowConversion;
    }

    public boolean isAllowMappingMethod() {
        return this.allowMappingMethod;
    }

    public boolean isAllow2Steps() {
        return this.allow2Steps;
    }

    public static SelectionCriteria forMappingMethods(SelectionParameters selectionParameters, MappingControl mappingControl, String targetPropertyName, boolean preferUpdateMapping) {
        return new SelectionCriteria(selectionParameters, mappingControl, targetPropertyName, preferUpdateMapping ? Type.PREFER_UPDATE_MAPPING : null);
    }

    public static SelectionCriteria forFactoryMethods(SelectionParameters selectionParameters) {
        return new SelectionCriteria(selectionParameters, null, null, Type.OBJECT_FACTORY);
    }

    public static SelectionCriteria forLifecycleMethods(SelectionParameters selectionParameters) {
        return new SelectionCriteria(selectionParameters, null, null, Type.LIFECYCLE_CALLBACK);
    }

    public static SelectionCriteria forPresenceCheckMethods(SelectionParameters selectionParameters) {
        return new SelectionCriteria(selectionParameters, null, null, Type.PRESENCE_CHECK);
    }

    public static enum Type {
        PREFER_UPDATE_MAPPING,
        OBJECT_FACTORY,
        LIFECYCLE_CALLBACK,
        PRESENCE_CHECK;

    }
}

