/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.model.source;

import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.mapstruct.ap.internal.gem.IterableMappingGem;
import org.mapstruct.ap.internal.gem.NullValueMappingStrategyGem;
import org.mapstruct.ap.internal.model.common.FormattingParameters;
import org.mapstruct.ap.internal.model.source.DelegatingOptions;
import org.mapstruct.ap.internal.model.source.MapperOptions;
import org.mapstruct.ap.internal.model.source.MappingControl;
import org.mapstruct.ap.internal.model.source.SelectionParameters;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.internal.util.FormattingMessager;
import org.mapstruct.ap.internal.util.Message;
import org.mapstruct.ap.internal.util.TypeUtils;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;

public class IterableMappingOptions
extends DelegatingOptions {
    private final SelectionParameters selectionParameters;
    private final FormattingParameters formattingParameters;
    private final IterableMappingGem iterableMapping;

    public static IterableMappingOptions fromGem(IterableMappingGem iterableMapping, MapperOptions mappperOptions, ExecutableElement method, FormattingMessager messager, TypeUtils typeUtils) {
        if (iterableMapping == null || !IterableMappingOptions.isConsistent(iterableMapping, method, messager)) {
            IterableMappingOptions options = new IterableMappingOptions(null, null, null, mappperOptions);
            return options;
        }
        SelectionParameters selection = new SelectionParameters(iterableMapping.qualifiedBy().get(), iterableMapping.qualifiedByName().get(), iterableMapping.elementTargetType().getValue(), typeUtils);
        FormattingParameters formatting = new FormattingParameters(iterableMapping.dateFormat().get(), iterableMapping.numberFormat().get(), iterableMapping.mirror(), iterableMapping.dateFormat().getAnnotationValue(), method);
        IterableMappingOptions options = new IterableMappingOptions(formatting, selection, iterableMapping, mappperOptions);
        return options;
    }

    private static boolean isConsistent(IterableMappingGem gem, ExecutableElement method, FormattingMessager messager) {
        if (!(gem.dateFormat().hasValue() || gem.numberFormat().hasValue() || gem.qualifiedBy().hasValue() || gem.qualifiedByName().hasValue() || gem.elementTargetType().hasValue() || gem.nullValueMappingStrategy().hasValue())) {
            messager.printMessage((Element)method, Message.ITERABLEMAPPING_NO_ELEMENTS, new Object[0]);
            return false;
        }
        return true;
    }

    private IterableMappingOptions(FormattingParameters formattingParameters, SelectionParameters selectionParameters, IterableMappingGem iterableMapping, DelegatingOptions next) {
        super(next);
        this.formattingParameters = formattingParameters;
        this.selectionParameters = selectionParameters;
        this.iterableMapping = iterableMapping;
    }

    public SelectionParameters getSelectionParameters() {
        return this.selectionParameters;
    }

    public FormattingParameters getFormattingParameters() {
        return this.formattingParameters;
    }

    public AnnotationMirror getMirror() {
        return Optional.ofNullable(this.iterableMapping).map(IterableMappingGem::mirror).orElse(null);
    }

    @Override
    public NullValueMappingStrategyGem getNullValueMappingStrategy() {
        return Optional.ofNullable(this.iterableMapping).map(IterableMappingGem::nullValueMappingStrategy).filter(GemValue::hasValue).map(GemValue::getValue).map(NullValueMappingStrategyGem::valueOf).orElse(this.next().getNullValueMappingStrategy());
    }

    public MappingControl getElementMappingControl(ElementUtils elementUtils) {
        return Optional.ofNullable(this.iterableMapping).map(IterableMappingGem::elementMappingControl).filter(GemValue::hasValue).map(GemValue::getValue).map(mc -> MappingControl.fromTypeMirror(mc, elementUtils)).orElse(this.next().getMappingControl(elementUtils));
    }

    @Override
    public boolean hasAnnotation() {
        return this.iterableMapping != null;
    }
}

